#include "mickymouse.h"
#include <QPainter>
#include <QDebug>
#include "egg.h"

MickyMouse::MickyMouse() :
    QGraphicsItem(),mCurrentPos(0)
{    
    mMickyMouse << QPixmap(":image/left_upper.png"); //0
    mMickyMouse << QPixmap(":image/left_lower.png"); //1
    mMickyMouse << QPixmap(":image/right_upper.png"); //2
    mMickyMouse << QPixmap(":image/right_lower.png"); //3
}

QRectF MickyMouse::boundingRect() const
{
    return QRectF(0,0,100,168);
}

void MickyMouse::paint ( QPainter *painter, const QStyleOptionGraphicsItem */*option*/, QWidget */*widget*/ )
{
    painter->drawPixmap(0,0,mMickyMouse.at(mCurrentPos));
}

void MickyMouse::catchEgg( Position pos)
{
    mCurrentPos = pos;
    switch( pos ) {
    case LowerLeft:
    case UpperLeft:
        this->setPos(180,167);
        break;
    case LowerRight:
    case UpperRight:
        this->setPos(330,167);
        break;
    }
}

int MickyMouse::position() const
{
    return mCurrentPos;
}

bool MickyMouse::isFallingInBasket( Egg* egg )
{
    switch( mCurrentPos ) {
    case 0: // upper left
        if( egg->x() >= 200 && egg->x() <= 220 && egg->y() >= 210 && egg->y() <= 250 ) {
            return true;
        }
        break;
    case 1: // lower left
        if( egg->base()->y() ==  280 && egg->x() >= 200 && egg->x() <= 220 && egg->y() >= 310 && egg->y() <= 350 ) {
            return true;
        }
        break;
    case 2: // upper right
        if( egg->x() <= 600 && egg->x() >= 560 && egg->y() >= 190 && egg->y() <= 230 ) {
            return true;
        }
        break;
    case 3: // lower right
        if( egg->base()->y() ==  280 && egg->x() <= 600 && egg->x() >= 560 && egg->y() >= 310 && egg->y() <= 350 ) {
            return true;
        }
        break;
    }
    return false;
}
