#include "roundrectbutton.h"
#include <QGraphicsTextItem>
#include <QPainter>
#include <QBrush>

RoundRectButton::RoundRectButton(const QString& buttonText,int fontSize, int buttonWidth )
    :TextButton(buttonText,fontSize),mButtonWidth(buttonWidth)
{
    setPressed(false);
}

void RoundRectButton::paint ( QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget )
{
    QBrush brush(Qt::SolidPattern);
    brush.setColor( !mIsPressed ? Qt::darkRed:QColor(255,255,195));
    painter->setBrush(brush);
    painter->drawRoundedRect( boundingRect() ,5,5);

    painter->save();
    painter->translate(mButtonWidth/2 - mTextItem->boundingRect().width()/2,0);
    TextButton::paint(painter,option,widget);
    painter->restore();
}

void RoundRectButton::setPressed(bool pressed)
{
    mIsPressed = pressed;
    mTextItem->setDefaultTextColor( !pressed ? QColor(255,255,150): Qt::black );
    update();
}

QRectF RoundRectButton::boundingRect() const
{
    QRectF boundingRect = TextButton::boundingRect();
    boundingRect.setWidth( mButtonWidth);
    return boundingRect;
}
