#include "pausedmenu.h"
#include "roundrectbutton.h"
#include <QDebug>
#include <QPainter>
#include <QColor>
#include <QGraphicsScene>

PausedMenu::PausedMenu(QGraphicsScene* scene)
    :AbscractScreen(scene)
{
    QGraphicsTextItem* title = createTextItem(40,true);
    title->setPlainText("Game Paused");
    title->setDefaultTextColor(QColor(255,255,195));
    title->setPos(400 - title->boundingRect().width()/2,150);

    RoundRectButton* resumeBtn = createRoundRectButton("Resume",20,300);
    resumeBtn->setPos(50,300);
    connect(resumeBtn,SIGNAL(clicked()),this,SIGNAL(resumeGame()));

    RoundRectButton* mainMenuBtn = createRoundRectButton("Main Menu",20,300);
    mainMenuBtn->setPos(800 -50 -mainMenuBtn->boundingRect().width(),300);
    connect(mainMenuBtn,SIGNAL(clicked()),this,SIGNAL(showMainMenu()));
}


