#ifndef HATCHINGEGG_H
#define HATCHINGEGG_H

#include <QGraphicsObject>
#include <QPixmap>
#include "egg.h"

class QGraphicsScene;

class HatchingEgg : public QGraphicsObject
{
    Q_OBJECT
public:
    HatchingEgg( Egg* egg, QGraphicsScene* scene);

    void paint ( QPainter * painter, const QStyleOptionGraphicsItem * /*option*/, QWidget * /*widget*/ );

    QRectF boundingRect() const;

    void nextFrame();

signals:

    void hatched( HatchingEgg* hatchedEgg);

private:

    QPixmap mEggImage;
    int mCurrentFrame;
    int mDelay;
};

#endif // HATCHINGEGG_H
