#include <QtGlobal>
#include <QButtonGroup>
#include <QMessageBox>
#include <QDebug>
#include <QGroupBox>

#include "window.h"
#include "CatView.h"
#include "CatViewList.h"
#include "EnumHeader.h"



#define MAX_NO_BLOCKS 11 
#define DIS_MAX 10000 // Maximum distance
#define MAX_NEIGHBORS 6 
#define difficulty 10 

static bool won = false;
static bool finished = false;
QGridLayout *grid ;

int catX = MAX_NO_BLOCKS/2;
int catY = MAX_NO_BLOCKS/2;

CatView catViewArray[MAX_NO_BLOCKS][MAX_NO_BLOCKS];

int prevCatX,prevCatY;

QButtonGroup *bgroup ;

QPushButton *btn; 

Window :: Window(QWidget *parent): QWidget(parent)
{
	CreateButtons();
	
}

//Creating Buttons

void Window:: CreateButtons()
{
	SetBackgroundImage();
	bgroup = new QButtonGroup(0) ;
        int locX = 30;
        int locY = 0;
        int width = 55;
        int height = 43;
        int index = 0;

        for(int x = 0; x < MAX_NO_BLOCKS; x++){
                for(int y = 0; y < MAX_NO_BLOCKS; y++){
                        btn = new QPushButton(this);
                        btn->setIconSize(QSize(65,43));
                        btn->setFlat(true);
                        if(x % 2 == 0)
                        {

                                btn->setGeometry(locX,locY,width,height);
                                btn->setIcon(QPixmap(":/images/free.png"));
                        }
  			else
			   {
                                btn->setGeometry(locX + (width/2),locY,width,height);
                                btn->setIcon(QPixmap(":/images/free.png"));
                         }
                         bgroup->addButton(btn,index);
                         locX = locX + width + 2;
                         index++;
                }
                locX = 30;
                locY = locY + height - 2  ;
        }
        connect(bgroup, SIGNAL(buttonClicked(int)), this, SLOT(setIcon(int)));
	QPushButton *newgame = new QPushButton(this);
	QPushButton *exit = new QPushButton(this);
	QPushButton *help = new QPushButton(this);

	help->setGeometry(700,130, 45,45);
	help->setIconSize(QSize(45,45));
	help->setIcon(QPixmap(":/images/help3.png"));
	help->setFlat(true);
	newgame->setGeometry(700,200, 45,45);
	newgame->setIconSize(QSize(45,45));
	newgame->setIcon(QPixmap(":/images/new3.png"));
	newgame->setFlat(true);
	exit->setGeometry(700,270, 45,45);
	exit->setIconSize(QSize(60,60));
	exit->setIcon(QPixmap(":/images/quit.png"));
	exit->setFlat(true);

	connect(help, SIGNAL(clicked()), this, SLOT(helpfun()));
	connect(newgame, SIGNAL(clicked()), this, SLOT(newGame()));
	connect(exit, SIGNAL(clicked()), this, SLOT(exitfun()));
	

        drawCat();

}

//Reset catViewArray
void Window :: resetArray()
{
	 for(int x = 0; x < MAX_NO_BLOCKS; x++)
                for(int y = 0; y < MAX_NO_BLOCKS; y++)
                        catViewArray[x][y].resetValues();
}

//Reset Layout for new game

void Window :: resetLayout()
{
        resetArray();
	catX = MAX_NO_BLOCKS/2;
	catY = MAX_NO_BLOCKS/2;
	for(int pos = 0; pos < MAX_NO_BLOCKS * MAX_NO_BLOCKS; pos++){

                      QAbstractButton *btn1 = bgroup->button(pos);
                      btn1->setIcon(QPixmap(":/images/free.png"));

	}
	catGame(true);
	defaultFilled();
	
	int pos1 = (catY * MAX_NO_BLOCKS) + catX;
	
	QAbstractButton *btn1 = bgroup->button(pos1);
	btn1->setIcon(QPixmap(":/images/1.png")); 
			
}

//Button Click Event

QAbstractButton *Window :: setIcon(int id)
{
	QAbstractButton  *btn1 = bgroup->button(id);
	int x = id / MAX_NO_BLOCKS;
	int y = id % MAX_NO_BLOCKS;

	if(markPlace(x,y))
	{
		finished = moveCat();
		QMessageBox msgbox;
		if(won){
                        disconnect(bgroup, SIGNAL(buttonClicked(int)), this, SLOT(setIcon(int)));
			int res = QMessageBox::warning(this, tr("CONGRATULATIONS!"),
                   		  tr("You Won................\n"
                      		  "Do you want to play a new game?"),
                   		  QMessageBox::Yes | QMessageBox::No,
                   		  QMessageBox::Yes);
                        switch(res){ 
				case QMessageBox::Yes:	
					newGame();
                        		break;
				case QMessageBox::No:
                        		close();
					break;
				}
				
			}
		else if(finished){
                        disconnect(bgroup, SIGNAL(buttonClicked(int)), this, SLOT(setIcon(int)));
				int res = QMessageBox::warning(this, tr("Cat Application"),
                   			tr("Cat Won................\n"
                      			"Do you want to play a new game?"),
                   			QMessageBox::Yes | QMessageBox::No,
                   			QMessageBox::Yes);
                       		switch(res){ 
						case QMessageBox::Yes:	
							newGame();
							break;
						case QMessageBox::No:
                       			     		close();
							break;
						}
                           }
		else{
			btn1->setIcon(QPixmap(":/images/fill.png"));
		}				
     		
	}	

	return btn1;
}

//New Game

void Window :: newGame()
{
	disconnect(bgroup, SIGNAL(buttonClicked(int)), this, SLOT(setIcon(int)));	
	won = false;
	resetLayout();
        connect(bgroup, SIGNAL(buttonClicked(int)), this, SLOT(setIcon(int)));
}

void Window :: exitfun()
{
	QMessageBox msgbox;
	int res = QMessageBox :: information(this, tr("EXIT!"), tr("Do you want to Exit?"), 
					     QMessageBox::Yes | QMessageBox::No, QMessageBox ::Yes);
	switch(res){
			case QMessageBox::Yes:
				close();
				break;
			case QMessageBox::No:
				
				break;
		    }
}

//Help

void Window :: helpfun()
{
	QMessageBox::information(this,"Help!", "Block the cat by clicking the blocks\n"
	"in such a way that it gets captured\n"
	"NOTE: Use 'Ctrl + Backspace'  to switch between applications");
	
		
	
}

// DrawCat

void Window :: drawCat()
{
	catGame(false);
	defaultFilled();
	
	int pos = (catY * MAX_NO_BLOCKS) + catX;
	QAbstractButton *btn1 = bgroup->button(pos);
	btn1->setIconSize(QSize(65,43));
	btn1->setIcon(QPixmap(":/images/1.png"));
}

// Initially filled blocks

void Window :: defaultFilled()
{
	 srand((unsigned int)time(0)); //Seed number for rand()
	 for(int pos = 0; pos < MAX_NO_BLOCKS * MAX_NO_BLOCKS; pos++)
         {
			int i = rand();
 			if ((i% difficulty) == 5){
			QAbstractButton  *btn1 = bgroup->button(pos);
        		btn1->setIcon(QPixmap(":/images/fill.png"));
			catViewArray[pos/MAX_NO_BLOCKS][pos%MAX_NO_BLOCKS].marked = true;
			catViewArray[pos/MAX_NO_BLOCKS][pos%MAX_NO_BLOCKS].whom = FILLED;
			}
		}
	
}
	
//Swap images

void Window :: swapImages(int catX,int catY, int prevCatX, int prevCatY)
{
	QAbstractButton *btn1, *btn2;
	int newPos = (catX * MAX_NO_BLOCKS) + catY;
	int oldPos = (prevCatX * MAX_NO_BLOCKS) + prevCatY;
	btn1 = bgroup->button(newPos);
	btn2 = bgroup->button(oldPos);
	int direction = 5;
	for( int i = 0; i < 6; i++)
	{
	if (getNeighborForDirection(i, prevCatX, prevCatY) == catViewArray[catX][catY]) {
			direction = i;
		break;
		}

	}
		
	switch(direction)
	{
		case 0:
			
			btn1->setIcon(QPixmap(":/images/bmp_cat_ul.png"));
			break;
		case 1:
			btn1->setIcon(QPixmap(":/images/bmp_cat_ur.png"));
			break;
		case 2:
			btn1->setIcon(QPixmap(":/images/bmp_cat_r.png"));
			break;
		case 3:
			btn1->setIcon(QPixmap(":/images/bmp_cat_dl.png"));
			break;
		case 4:
			btn1->setIcon(QPixmap(":/images/bmp_cat_dr.png"));
			break;
		case 5:
			btn1->setIcon(QPixmap(":/images/bmp_cat_l.png"));
			break;
		}
         	btn2->setIcon(QPixmap(":/images/free.png"));
	
}

//Assigning Values for catViewArray

void Window :: catGame(bool firstGame)
{
	int x, y;
	int count = 0;
	for (x = 0; x < MAX_NO_BLOCKS; x++) {
                for (y = 0; y < MAX_NO_BLOCKS; y++) {
       	            	if ((x == MAX_NO_BLOCKS / 2) && (y == MAX_NO_BLOCKS / 2)) { // Cat location
					if(firstGame)
					{
                				catViewArray[x][y] = CatView(x, y, CAT, count);
					}
					else
					{
						
					catViewArray[x][y].x = x;
					catViewArray[x][y].y = y;
					catViewArray[x][y].whom = CAT;

					}
					catViewArray[x][y].whom = CAT;
	        	       		catViewArray[x][y].marked = false; // place with cat must not be marked
			}
			else{
					if(firstGame)
					{
						catViewArray[x][y] = CatView(x, y, FREE, count);
					}
					else
					{
						
					catViewArray[x][y].x = x;
					catViewArray[x][y].y = y;
					catViewArray[x][y].whom = FREE;
					}

			}
			
		count++;
		}
	}
	escapePos();
}

//Move cat 

bool Window :: moveCat()
{
	prevCatX = catX;
	prevCatY = catY;
	
	CatViewList shortestPathes;
	srand(time(0));

	int shortestPathesSize = 0;
	shortestPathesSize = calcShortestPathes(shortestPathes);
	if (shortestPathes.IsListEmpty()) {	
		 // no escape reachable
		CatView neighbors[MAX_NEIGHBORS];
            	
		getNeighbors(catX, catY, neighbors);

            	CatViewList reachableNeighbors;

            	int size = 0;
            	for (int i = 0; i < MAX_NEIGHBORS; i++) {
                	CatView neighbor = neighbors[i];
               	 	if (!neighbor.marked) {
                  		reachableNeighbors.Append(neighbor);
                  		size++;
                	}
            }

            if (size == 0) { // All neighbors marked/filled
                won = true;
                return true;
            }
 	    int direction = qAbs(rand()) % size;
	    CatView randNeighbor = reachableNeighbors.ElementAtIndex(direction);

            catX = randNeighbor.x;
            catY = randNeighbor.y;
        
	    reachableNeighbors.Clear();
        } else {
		int rp = qAbs(rand()) % shortestPathesSize;  
		CatView prevPlace = shortestPathes.ElementAtIndex(rp);
		CatView reachedFromPlace = catViewArray[prevPlace.reachedFromX][prevPlace.reachedFromY];
		
		while (reachedFromPlace != catViewArray[catX][catY]) {// Moving towards CAT's adjacent neighbor
                prevPlace = reachedFromPlace;
                reachedFromPlace = catViewArray[prevPlace.reachedFromX][prevPlace.reachedFromY];
            }

	    catX = prevPlace.x;
            catY = prevPlace.y;
        }
	  // Change the cat position


        catViewArray[prevCatX][prevCatY].whom = FREE;
        catViewArray[catX][catY].whom = CAT;

	swapImages(catX ,catY, prevCatX, prevCatY); 
        

	if (catViewArray[catX][catY].escape) {
            won = false;
            return true;
        }
        shortestPathes.Clear();
        
         return false;
}

//Calculating Shortest path

int Window :: calcShortestPathes(CatViewList& shortestPathes)
{
	int shortestPathesSize = 0;
        for (int x = 0; x < MAX_NO_BLOCKS; x++) {
           for (int y = 0; y < MAX_NO_BLOCKS; y++) {
		    catViewArray[x][y].visited = false;
	            catViewArray[x][y].distance = DIS_MAX;
	            catViewArray[x][y].reachedFromX = 0;
	            catViewArray[x][y].reachedFromY = 0;
	            }
	     }

        // Setting values for current location i.e. CAT location
           catViewArray[catX][catY].distance = 0;
           catViewArray[catX][catY].visited = true;
	   CatViewList queue;
           int queueSize = 0;
           queue.Append(catViewArray[catX][catY]);
           queueSize++;

	   int shortestEscape = DIS_MAX;

	   CatView actPlace;
          // dijkstra
           while (queueSize > 0) {
		   if ((queue.Pop(actPlace)) == -1)   break;
			
		    queueSize--;
		    CatView neighbors[MAX_NEIGHBORS];
	       	    
		    getNeighbors(actPlace.x, actPlace.y, neighbors);
		
		    for (int i = 0; i < MAX_NEIGHBORS; i++) {
		          CatView neighbor = neighbors[i];
		          if (neighbor.marked) // Already marked
		          {
				continue;
                	  }
		int newDistance = actPlace.distance + 1;
                if (newDistance < neighbor.distance) { // Update neighbor's distance
                     	neighbor.distance = newDistance;
                     	neighbor.reachedFromX = actPlace.x;
                	neighbor.reachedFromY = actPlace.y;
			catViewArray[neighbor.x][neighbor.y] = neighbor;
		}
                
		if (!neighbor.visited && !neighbor.escape) {
	        	neighbor.visited = true;		
	        	catViewArray[neighbor.x][neighbor.y].visited = true;		
			queue.Append(neighbor);
			queueSize++;
		}
		
		if (neighbor.escape) {
			 if (neighbor.distance < shortestEscape) { // Shortest node
	                       shortestEscape = neighbor.distance;
	                       shortestPathes.Clear();
	                       shortestPathes.Append(neighbor);
			       shortestPathesSize = 1;
		        } else if (neighbor.distance == shortestEscape) { // Eqi-distance Shortest node
	                        shortestPathes.Append(neighbor);
	                        shortestPathesSize++;
		   }
		}
	    }
         }

           queue.Clear();
	
   
	   return shortestPathesSize;
}

//for Available neighbors

void Window :: getNeighbors(int x, int y, CatView catViewArr[])
{
        for (int i = 0; i < MAX_NEIGHBORS; i++) {
            catViewArr[i] = getNeighborForDirection(i, x, y);	
	}
}

// Directions for Available Neighbors

CatView Window :: getNeighborForDirection(int direction, int x, int y)
{
	CatView neighbor;
       if (x % 2 == 0) {                   
            switch (direction) {
                case 0:
                    neighbor = catViewArray[x - 1][y - 1]; // UL
                    break;
                case 1:
                    neighbor = catViewArray[x - 1][y];  //UR
                    break;
                case 2:
                    neighbor = catViewArray[x][y + 1]; //R
                    break;
                case 3:
                      neighbor = catViewArray[x + 1][y - 1]; //DL
                    break;
                case 4:
                    neighbor = catViewArray[x + 1][y];  //DR
                    break;
                case 5:
                    neighbor = catViewArray[x][y - 1]; //L
                    break;
            }
        } else {                   
            switch (direction) {
                case 0:
                    neighbor = catViewArray[x - 1][y]; // UL
                    break;
                case 1:
                    neighbor = catViewArray[x - 1][y + 1]; //UR
                    break;
                case 2:
                    neighbor = catViewArray[x][y + 1]; //R
                    break;
                case 3:
                    neighbor = catViewArray[x + 1][y]; //DL
                    break;
                case 4:
                    neighbor = catViewArray[x + 1][y + 1]; //DR
                    break;
                case 5:
                    neighbor = catViewArray[x][y - 1]; //L
                    break;
            }
        }  
  	return neighbor;
}

//MarkPlace

bool Window :: markPlace(int x, int y)
{
	if ((x == catX) && (y == catY)) {
            return false;
        }
        if (catViewArray[x][y].marked) {
            return false;
        }

        catViewArray[x][y].marked = true;
	catViewArray[x][y].whom = FILLED;

        return true;
    }

//Escape positions for cat

void Window :: escapePos()
{
	for (int x = 0; x < MAX_NO_BLOCKS; x++) {
                for (int y = 0; y < MAX_NO_BLOCKS; y++) {
                    if ((x == 0) || (x == MAX_NO_BLOCKS - 1) || (y == 0) || (y == MAX_NO_BLOCKS - 1)) 
                        catViewArray[x][y].escape = true;
                    else 
                        catViewArray[x][y].escape = false;
                    
                }
            }

}

//Background Image

void Window :: SetBackgroundImage()
{
	QPalette p = palette();
	QPixmap pixmap1(":/images/scene.jpg");
	QDesktopWidget* desktopWidget = QApplication::desktop();
	QRect rect = desktopWidget->availableGeometry();
	QSize size(800,600);
	QPixmap pixmap(pixmap1.scaled(size));
 
	p.setBrush(QPalette::Background,  pixmap);
	setPalette(p);
}

