#ifndef COUNTDOWN_PLUGIN_H
#define COUNTDOWN_PLUGIN_H

#include <glib-object.h>

#include <libhildondesktop/libhildondesktop.h>

G_BEGIN_DECLS

typedef struct _CountdownPlugin CountdownPlugin;
typedef struct _CountdownPluginClass CountdownPluginClass;

#define COUNTDOWN_TYPE_HOME_PLUGIN   (countdown_home_plugin_get_type ())

#define COUNTDOWN_HOME_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                        COUNTDOWN_TYPE_HOME_PLUGIN, CountdownHomePlugin))

#define COUNTDOWN_HOME_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
                        COUTNDOWN_TYPE_HOME_PLUGIN,  CountdownHomePluginClass))

#define COUNTDOWN_IS_HOME_PLUGIN(obj)  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                        COUNTDOWN_TYPE_HOME_PLUGIN))
 
#define COUNTDOWN_IS_HOME_PLUGIN_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                        COUNTDOWN_TYPE_HOME_PLUGIN))

#define COUNTDOWN_HOME_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                        COUNTDOWN_TYPE_HOME_PLUGIN,  CountdownHomePluginClass))
 
struct _CountdownPlugin
{
    HDHomePluginItem hitem;
    GtkWidget *homeWidget;
    GtkWidget *contents;
	GtkWidget *upButton, *downButton;
    GtkListStore *entries;
    guint refresh;
	guint offset;
    guint eventID;
};
 
struct _CountdownPluginClass
{
    HDHomePluginItemClass parent_class;
};
 
GType countdown_home_plugin_get_type(void);

G_END_DECLS

#endif
