/*
 * This file is part of contactinfos
 *
 * Copyright (C) 2007 FLL.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <glib.h>
#include <contactinfos.h>


void freeContactInfosValue(ContactInfosValue *value) {
	if (value) {
		g_free(value->type);
		g_free(value->value);
		g_free(value);
	}
}

void freeContactInfosElement(ContactInfosElement *record) {
	if (record) {
		g_free(record->name);
		g_free(record->company);
		g_ptr_array_foreach(record->valueArray, (GFunc)freeContactInfosValue, NULL);
		g_ptr_array_free(record->valueArray, TRUE);
		g_free(record);
	}
}
