/*
 * This file is part of contactinfos
 *
 * Copyright (C) 2007 FLL.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
 
#ifndef BACKEND_H
#define BACKEND_H

#include <glib.h>
#include <gmodule.h>
#include <contactinfos.h>
#include <config.h>

#define LIBDIR "/usr/lib"
#define LIB_TEMPLATE LIBDIR"/lib%s.so"
#define GPE_MODULE "contactinfos_gpe"
#define EDS_MODULE "contactinfos_eds"
#define GOOGLE_MODULE "contactinfos_google"

#define INIT_BACKEND_SYMBOL "Backend_Init"
#define BACKEND_GET_AVAILABLE_CONTACTINFOS_SYMBOL "Backend_GetAvailableContactInfos"
#define BACKEND_GET_CONTACTINFOS_SYMBOL "Backend_GetContactInfos"
#define TERMINATE_BACKEND_SYMBOL "Backend_Terminate"

typedef gboolean (* tdInitBackend) (gpointer *data, GError ** error);
typedef gboolean (* tdTerminateBackend) (gpointer data, GError ** error);
typedef gboolean (* tdBackendGetAvailableContactInfos) (gpointer data, guint requestedInfos, guint* availableInfos, GError ** error);
typedef gboolean (* tdBackendGetContactInfos) (gpointer data, guint requestedInfos, const gchar * searchText, GSList **response, GError ** error);

typedef struct _BackendData BackendData;
struct _BackendData {
	GModule *module;
	gpointer backendData;
	gchar *prefix;
	tdInitBackend backendInit;
	tdTerminateBackend backendTerminate;
	tdBackendGetAvailableContactInfos backendGetAvailableContactInfos;
	tdBackendGetContactInfos backendGetContactInfos;
};

gboolean initBackend(gpointer *data, GError ** error);
gboolean terminateBackend(gpointer data, GError ** error);
gboolean backendGetAvailableContactInfos (gpointer data, guint requestedInfos, guint* availableInfos, GError ** error);
gboolean backendGetContactInfos (gpointer data, guint requestedInfos, const gchar * searchText, GSList **response, GError ** error);
void freeContactInfosRecord(ContactInfosElement *record);
void freeContactInfosValue(ContactInfosValue *value);


#endif
