/*
 * This file is part of contactinfos
 *
 * Copyright (C) 2007 FLL.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "contactinfos.h"
#include "contacts-eds.h"

#include <gmodule.h>
#include <glib.h>

G_MODULE_EXPORT gboolean Backend_Init(gpointer *data, GError ** error) {

#ifdef DEBUG
	g_printf("Backend_Init\n");
#endif
	return eds_open_pl (error);
	
}

G_MODULE_EXPORT gboolean Backend_GetAvailableContactInfos (gpointer data, guint requestedInfos, guint* availableInfos, GError ** error) {
	*availableInfos = CI_NOTHING;
#ifdef DEBUG
	g_printf("Backend_GetAvailableContactInfos\n requestedInfos=%d,\n EVERYTHING=%d,\n availableInfos=%d,...)\n", requestedInfos, CI_EVERYTHING, *availableInfos);
#endif
	if (requestedInfos == CI_EVERYTHING) {
		/*
		*availableInfos = CI_PHONE_NUMBER | CI_MOBILE_PHONE_NUMBER | CI_FAX_PHONE_NUMBER | CI_FULL_ADDRESS | CI_EMAIL | CI_VALUE_TYPE | CI_NAME | CI_COMPANY;
		*/
		*availableInfos = CI_PHONE_NUMBER | CI_EMAIL | CI_WEB | CI_VALUE_TYPE | CI_NAME;
		return TRUE;
	} 
	if (requestedInfos & CI_PHONE_NUMBER) {
		*availableInfos |= CI_PHONE_NUMBER;
	}
	/*
	if (requestedInfos & CI_MOBILE_PHONE_NUMBER) {
		*availableInfos |= CI_MOBILE_PHONE_NUMBER;
	}
	if (requestedInfos & CI_FAX_PHONE_NUMBER) {
		*availableInfos |= CI_FAX_PHONE_NUMBER;
	}
	*/
	if (requestedInfos & CI_EMAIL) {
		*availableInfos |= CI_EMAIL;
	}
	if (requestedInfos & CI_WEB) {
		*availableInfos |= CI_WEB;
	}
	/*
	if (requestedInfos & CI_FULL_ADDRESS) {
		*availableInfos |= CI_FULL_ADDRESS;
	}
	*/
	if (*availableInfos != CI_NOTHING) {
		/*
		*availableInfos |= CI_VALUE_TYPE | CI_NAME | CI_COMPANY;
		*/
		*availableInfos |= CI_VALUE_TYPE | CI_NAME;
	}
#ifdef DEBUG
	g_printf(" availableInfos=%d,...)\n", *availableInfos);
#endif
	return TRUE;
}

G_MODULE_EXPORT gboolean Backend_GetContactInfos (gpointer data, guint requestedInfos, const gchar * searchText, GSList **response, GError ** error) {
	guint availableInfos;
	gboolean ret;
#ifdef DEBUG
	g_printf("Backend_GetContactInfos (gpointer data=%p,\n guint requestedInfos=%d,\n const gchar * searchText=%s,...)\n", data, requestedInfos, searchText);
#endif
	ret = Backend_GetAvailableContactInfos (data, requestedInfos, &availableInfos, error);
#ifdef DEBUG
	g_printf("Backend_GetContactInfos availableInfos=%d,...)\n", availableInfos);
#endif
	if (ret) {
		if (availableInfos != CI_NOTHING) {
			return eds_get_phone_list(searchText, availableInfos, response, error);
		}
	} else {
		return FALSE;
	}
	return TRUE;
}

G_MODULE_EXPORT gboolean Backend_Terminate(gpointer data, GError ** error) {
	return eds_close_pl(error);
}

