#!/usr/bin/env python
# -*- coding: utf-8 -*-

#Libraries
######################################################
import conic
import dbus
import gobject
from dbus.mainloop.glib import DBusGMainLoop
dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)

#Files
######################################################
from Config import Config
from Notifications import Notifications

#Classes
######################################################
class Daemon:
	def __init__(self):
		self.Config = Config(self)
		self.Config.startNotifier()
		self.Notifications = Notifications(self)
		self.bus = dbus.bus.BusConnection("unix:path=/var/run/dbus/system_bus_socket")
		self.object = self.bus.get_object('com.nokia.mce', '/com/nokia/mce/request')
		self.bus.add_signal_receiver(self.chagerDisconnected, path='/com/nokia/bme/signal', dbus_interface='com.nokia.bme.signal', signal_name='charger_disconnected')
		self.interface = dbus.Interface(self.object, dbus_interface='com.nokia.mce.request')
		self.loop = gobject.MainLoop()
		self.iapId = False
		self.bearer = False
		self.security = None
		self.connection = conic.Connection()
		self.connection.connect('connection-event', self.handleConnectionEvent)

	def start(self):
		self.connection.set_property('automatic-connection-events', True)
		self.loop.run()
		self.stop()

	def stop(self):
		self.connection.set_property('automatic-connection-events', False)
		self.loop.quit()

	def handleConnectionEvent(self, connection, event):
		status = event.get_status()
		if status == conic.STATUS_CONNECTED:
			self.iapId = event.get_iap_id()
			self.bearer = event.get_bearer_type()
			self.refreshSecurity()
		elif status == conic.STATUS_DISCONNECTING:
			self.iapId = False
			self.bearer = False
			self.setSecurity(True)

	def chagerDisconnected(self):
		if self.Config.instantLockOnDetach:
			self.lock()

	def refreshSecurity(self):
		if (self.bearer == 'WLAN_INFRA' and self.iapId in self.Config.trustedWlans) or (self.bearer != 'WLAN_INFRA' and self.iapId in self.Config.trustedMobileNetworks):
			self.setSecurity(False)
		else:
			self.setSecurity(True)

	def setSecurity(self, status):
		if status != self.security:
			self.security = status
			if status:
				self.Config.client.set_bool("/system/osso/dsm/locks/devicelock_autolock_enabled", True)
				self.notify("Security is now enabled")
				if self.Config.instantLockOnDisconnect:
					self.lock()					
			else:
				self.Config.client.set_bool("/system/osso/dsm/locks/devicelock_autolock_enabled", False)
				self.unlock()
				self.notify("Security is now disabled")

	def unlock(self):
		try: #TODO: Something smarter?
			self.interface.devlock_callback(dbus.Int32("2"), timeout = 0)
		except dbus.exceptions.DBusException:
			pass

	def lock(self):
		try: #TODO: Something smarter?
			self.interface.devlock_callback(dbus.Int32("3"), timeout = 0)
		except dbus.exceptions.DBusException:
			pass

	def notify(self, text):
		if(self.Config.notifications):
			self.Notifications.notify(text)

#Run
######################################################
if __name__ == '__main__':
	daemon = Daemon()
	daemon.start()

#Applet: timeout, notifications, battery, networks
