#ifndef WRITEWINDOW_H
#define WRITEWINDOW_H

#include <QMainWindow>
#include <QTextStream>
#include <QFile>
#include <QDir>
#include <QDate>
#include <QTime>
#include <QFile>
#include <QFileDialog>
#include <QDesktopServices>
#include <QUrl>

class configReader;

namespace Ui {
    class writeWindow;
}

class writeWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit writeWindow(QWidget *parent = 0);
    ~writeWindow();

public slots:
    void writeFile();
    void openFile();

private:
    Ui::writeWindow *ui;
    configReader *writeParent;

    int i;
    int bodyTagPos;
    QString preSaveFileName;
    QFile saveFile;
    QDir bkpDir;
    QTextStream writeStrm;
    QDate curDate;
    QTime curTime;
    QStringList outDataSplitted;
    QString tempData;
    float fI; // int i to float
    float fLen; // Length of outDataSplitted
    int percDone; // Percentage for the progressbar
    float fPercDone; // Float version of percDone
    int carPos;
    QString fileCopy1;
    QString fileCopy2;
    QStringList fileContSplitted1;
    QStringList fileContSplitted2;
    QStringList fileDiffList;
    QString preDirString;
    QString dirString;
    QString fileDiff;
    enum fileNumber {
        first,
        second
    } sourceNum;

    void editOutData();
    void outputDiff();
    void saveDifference(QStringList &source, QStringList &compare);
};

#endif // WRITEWINDOW_H
