#include "settingsdialog.h"
#include "ui_settingsdialog.h"

#include "configreader.h"
#include "ui_configreader.h"

#include <QDebug>

settingsDialog::settingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::settingsDialog)
{
    ui->setupUi(this);
    // settParent is settDialog's parent (configReader)
    settParent = (configReader*) parent;

    ui->explLbl->adjustSize();

    // Set dateFormat radiobuttons acoording to current values
    ui->radDDMMYY->setChecked(false);
    ui->radMMDDYY->setChecked(false);
    ui->radYYDDMM->setChecked(false);
    ui->radYYMMDD->setChecked(false);
    if(settParent->dateFormat == "ddMMyy")
        ui->radDDMMYY->setChecked(true);
    else if(settParent->dateFormat == "MMddyy")
        ui->radMMDDYY->setChecked(true);
    else if(settParent->dateFormat == "yyddMM")
        ui->radYYDDMM->setChecked(true);
    else if(settParent->dateFormat == "yyMMdd")
        ui->radYYMMDD->setChecked(true);

    // Set separator radiobuttons according to current values
    ui->sepDash->setChecked(false);
    ui->sepSlash->setChecked(false);
    ui->sepNone->setChecked(false);
    if(settParent->dateSep == "-")
        ui->sepDash->setChecked(true);
    else if(settParent->dateSep == "/")
        ui->sepSlash->setChecked(true);
    else if(settParent->dateSep == "")
        ui->sepNone->setChecked(true);

    // Put the separator in the settParent->dateFormat radio buttons
    ui->radDDMMYY->setText("DD" + settParent->dateSep + "MM" + settParent->dateSep + "YY");
    ui->radMMDDYY->setText("MM" + settParent->dateSep + "DD" + settParent->dateSep + "YY");
    ui->radYYDDMM->setText("YY" + settParent->dateSep + "DD" + settParent->dateSep + "MM");
    ui->radYYMMDD->setText("YY" + settParent->dateSep + "MM" + settParent->dateSep + "DD");

    connect(ui->radDDMMYY, SIGNAL(toggled(bool)),
            this, SLOT(ddmmyy()));
    connect(ui->radMMDDYY, SIGNAL(toggled(bool)),
            this, SLOT(mmddyy()));
    connect(ui->radYYDDMM, SIGNAL(toggled(bool)),
            this, SLOT(yyddmm()));
    connect(ui->radYYMMDD, SIGNAL(toggled(bool)),
            this, SLOT(yymmdd()));

    connect(ui->sepDash, SIGNAL(toggled(bool)),
            this, SLOT(sepDash()));
    connect(ui->sepSlash, SIGNAL(toggled(bool)),
            this, SLOT(sepSlash()));
    connect(ui->sepNone, SIGNAL(toggled(bool)),
            this, SLOT(sepNone()));

    connect(this->ui->btnBox, SIGNAL(accepted()),
            this, SLOT(close()));

    this->adjustSize();
}

settingsDialog::~settingsDialog()
{
    delete ui;
}





// Change settParent->dateFormat and save the date_format GConf values
void settingsDialog::ddmmyy() { settParent->dateFormat = "ddMMyy";
                              system("gconftool -s /apps/maemo/configreader/date_format -t string \"ddMMyy\""); }
void settingsDialog::mmddyy() { settParent->dateFormat = "MMddyy";
                              system("gconftool -s /apps/maemo/configreader/date_format -t string \"MMddyy\""); }
void settingsDialog::yyddmm() { settParent->dateFormat = "yyddMM";
                              system("gconftool -s /apps/maemo/configreader/date_format -t string \"yyddMM\""); }
void settingsDialog::yymmdd() { settParent->dateFormat = "yyMMdd";
                              system("gconftool -s /apps/maemo/configreader/date_format -t string \"yyMMdd\""); }





// Change settParent->dateSep, save date_sep GConf value and update settParent->dateFormat radiobuttons
void settingsDialog::sepDash() {
    settParent->dateSep = "-";
    system("gconftool -s /apps/maemo/configreader/date_sep -t string \"dash\"");
    // Put the separator in the settParent->dateFormat radio buttons
    ui->radDDMMYY->setText("DD" + settParent->dateSep + "MM" + settParent->dateSep + "YY");
    ui->radMMDDYY->setText("MM" + settParent->dateSep + "DD" + settParent->dateSep + "YY");
    ui->radYYDDMM->setText("YY" + settParent->dateSep + "DD" + settParent->dateSep + "MM");
    ui->radYYMMDD->setText("YY" + settParent->dateSep + "MM" + settParent->dateSep + "DD");
}
void settingsDialog::sepSlash() {
    settParent->dateSep = "/";
    system("gconftool -s /apps/maemo/configreader/date_sep -t string \"slash\"");
    ui->radDDMMYY->setText("DD" + settParent->dateSep + "MM" + settParent->dateSep + "YY");
    ui->radMMDDYY->setText("MM" + settParent->dateSep + "DD" + settParent->dateSep + "YY");
    ui->radYYDDMM->setText("YY" + settParent->dateSep + "DD" + settParent->dateSep + "MM");
    ui->radYYMMDD->setText("YY" + settParent->dateSep + "MM" + settParent->dateSep + "DD");
}
void settingsDialog::sepNone() {
    settParent->dateSep = "";
    system("gconftool -s /apps/maemo/configreader/date_sep -t string \"none\"");
    ui->radDDMMYY->setText("DD" + settParent->dateSep + "MM" + settParent->dateSep + "YY");
    ui->radMMDDYY->setText("MM" + settParent->dateSep + "DD" + settParent->dateSep + "YY");
    ui->radYYDDMM->setText("YY" + settParent->dateSep + "DD" + settParent->dateSep + "MM");
    ui->radYYMMDD->setText("YY" + settParent->dateSep + "MM" + settParent->dateSep + "DD");
}
