/* This file is part of Conboy.
 *
 * Copyright (C) 2009 Cornelius Hald
 *
 * Conboy is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Conboy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Conboy. If not, see <http://www.gnu.org/licenses/>.
 */

#include "localisation.h"

#include <hildon/hildon-program.h>
#include <gtk/gtkmain.h>
#include <libosso.h>
#include <mce/dbus-names.h>
#include <mce/mode-names.h>
#ifdef HILDON_HAS_APP_MENU
#include <hildon/hildon-gtk.h>
#endif

#include "app_data.h"
#include "settings.h"
#include "search_window.h"
/*#include "json.h"*/


#define APP_NAME "conboy"
#define APP_SERVICE "de.zwong.conboy"
#define APP_METHOD "/de/zwong/conboy"

#define MCE_MATCH_RULE "type='signal',interface='" MCE_SIGNAL_IF "',member='" MCE_DEVICE_ORIENTATION_SIG "'"

static void cleanup()
{
	AppData *app_data = app_data_get();
	GtkTreeIter iter;
	GtkTreeModel *model = GTK_TREE_MODEL(app_data->note_store);
	gboolean valid = gtk_tree_model_get_iter_first(model, &iter);
	while (valid) {
		Note *note;
		gtk_tree_model_get(model, &iter, NOTE_COLUMN, &note, -1);
		note_free(note);
		valid = gtk_tree_model_iter_next(model, &iter);
	}

	/* Free AppData */
	app_data_free();
}

#ifdef HILDON_HAS_APP_MENU
static void
set_orientation(const gchar* orientation)
{
	g_printerr("INFO: Setting to orientation: %s\n", orientation);

	HildonPortraitFlags flags;
	AppData *app_data = app_data_get();

	if (strcmp(orientation, "landscape") == 0) {
		flags = HILDON_PORTRAIT_MODE_SUPPORT;
		app_data->portrait = FALSE;
	} else if (strcmp(orientation, "portrait") == 0) {
		flags = HILDON_PORTRAIT_MODE_REQUEST;
		app_data->portrait = TRUE;
	} else {
		g_printerr("ERROR: Orientation must be 'landscape' or 'portrait', not '%s'.\n", orientation);
		return;
	}

	/* Switch the orientation of all open note windows */
	GList *open_notes = app_data->open_notes;
	while (open_notes != NULL) {
		Note *note = (Note*)open_notes->data;
		hildon_gtk_window_set_portrait_flags(GTK_WINDOW(note->ui->window), flags);
		open_notes = open_notes->next;
	}

	/* Switch the orientation of the search window */
	if (app_data->search_window != NULL) {
		hildon_gtk_window_set_portrait_flags(GTK_WINDOW(app_data->search_window), flags);
	}

}

static DBusHandlerResult
dbus_handle_mce_message(DBusConnection *con, DBusMessage *msg, gpointer data)
{
	DBusMessageIter iter;
	const gchar *mode = NULL;
	/* TODO: Maybe handle other MCE message here. Like memory too high... */
	if (dbus_message_is_signal(msg, MCE_SIGNAL_IF, MCE_DEVICE_ORIENTATION_SIG)) {
		if (dbus_message_iter_init(msg, &iter)) {
			dbus_message_iter_get_basic(&iter, &mode);
			set_orientation(mode);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}

static gint
orientation_handler(const gchar *iface, const gchar *method, GArray *args, gpointer data, osso_rpc_t *retval)
{
	g_printerr("IFACE: %s\n", iface);
	g_printerr("METHOD: %s\n", method);
}

/*
gboolean
check_device_position(DBusConnection *connection){
    DBusError derror;
    char *mode;
    DBusMessage *message, *reply;

    if (!connection){
    	g_printerr("No connection\n");
        return FALSE;
    }

    message = dbus_message_new_method_call(MCE_SERVICE,
                                   MCE_REQUEST_PATH,
                                   MCE_REQUEST_IF,
                                   MCE_DEVICE_ORIENTATION_GET);

    dbus_error_init(&derror);
    reply = dbus_connection_send_with_reply_and_block(connection, message,
                                                      -1, &derror);
    dbus_message_unref(message);
    if (dbus_error_is_set(&derror)) {
        fprintf(stderr,"Getting device mode from MCE failed: %s", derror.message);
        dbus_error_free(&derror);
        return FALSE;
    }

    if (!dbus_message_get_args(reply, NULL,
                               DBUS_TYPE_STRING, &mode,
                               DBUS_TYPE_INVALID)) {
        error(0, 0, "Invalid arguments for MCE get_device_orientation reply");
        dbus_message_unref(reply);
        return FALSE;
    }

    g_printerr("MODE: %s\n", mode);

    if (!strcmp(mode, "portrait")) {
    	dbus_message_unref(reply);
        return TRUE;
    } else {
    	dbus_message_unref(reply);
        return FALSE;
    }

}
*/


gboolean
dbus_is_portrait_mode(osso_context_t* ctx)
{
	osso_rpc_t ret;
	gboolean result = FALSE;

	if (osso_rpc_run_system(ctx, MCE_SERVICE, MCE_REQUEST_PATH,
			MCE_REQUEST_IF,	MCE_DEVICE_ORIENTATION_GET, &ret, DBUS_TYPE_INVALID) == OSSO_OK) {

		g_printerr("INFO: DBus said orientation is: %s\n", ret.value.s);

		if (strcmp(ret.value.s, "portrait") == 0) {
			result = TRUE;
		}

		osso_rpc_free_val(&ret);

	} else {
		g_printerr("ERROR: Call do DBus failed\n");
	}

	return result;

	/*
	DBusConnection *con = osso_get_sys_dbus_connection(ctx);
	DBusMessage *msg, *reply;
	DBusError error;

	msg = dbus_message_new_method_call(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF,
			MCE_DEVICE_ORIENTATION_GET);

	dbus_error_init(&error);

	reply = dbus_connection_send_with_reply_and_block(con, msg, -1, &error);

	if (dbus_error_is_set(&error)) {
		g_printerr("ERROR: Failed: %s\n", error.message);
	}

	if (reply == NULL) {
		g_printerr("ERROR: Reply is NULL\n");
	}

	gchar *mode;
	dbus_message_get_args(reply, NULL, DBUS_TYPE_STRING, &mode, DBUS_TYPE_INVALID);

	g_printerr("MODE: %s \n", mode);
*/

}
#endif

int
main (int argc, char *argv[])
{
  HildonProgram *program;
  Note *note;
  osso_context_t *osso_context;
  AppData *app_data;

  /* Init i18n */
  locale_init();

  /* Init GTK */
#ifdef HILDON_HAS_APP_MENU
  g_printerr("HILDON INIT \n");
  hildon_gtk_init(&argc, &argv);
#else
  gtk_init(&argc, &argv);
#endif

  /* Call this to initialize it */
  app_data = app_data_get();

  /* Initialize maemo application */
  g_printerr("Starting %s, Version %s \n", APP_NAME, VERSION);
  osso_context = osso_initialize(APP_SERVICE, VERSION, TRUE, NULL);

  /* Check that initialization was ok */
  if (osso_context == NULL) {
      return OSSO_ERROR;
  }

  /* Get the DBus connection */
  DBusConnection *con = osso_get_sys_dbus_connection(osso_context);

#ifdef HILDON_HAS_APP_MENU
  /* Get current orientation from DBus and save into app_data */
  app_data->portrait = dbus_is_portrait_mode(osso_context);

  /* Add a matchin rule */
  dbus_bus_add_match(con, MCE_MATCH_RULE, NULL);

  /* Add the callback, which should be called, once the device is rotated */
  dbus_connection_add_filter(con, dbus_handle_mce_message, NULL, NULL);
#endif



  /* Create the Hildon program and setup the title */
  program = HILDON_PROGRAM(hildon_program_get_instance());
  g_set_application_name("Conboy");

  if (settings_load_startup_window() == SETTINGS_STARTUP_WINDOW_NOTE) {
	  /* Get the most recent note. If there is none, create new. */
	  note = note_list_store_get_latest(app_data->note_store);
	  if (note == NULL) {
		  note = note_create_new();
	  }
	  note_show(note);
  } else {
	  search_window_open();
  }



  /*******/
  /*
  print_note_as_json(note);
  JsonNode *node = get_json_object_from_note(note);
  Note *xnote = get_note_from_json_object(node);
  g_printerr("### %s \n", xnote->guid);
  g_printerr("### %s \n", xnote->title);
  g_printerr("### %f \n", xnote->content_version);
  g_printerr("### %f \n", xnote->version);
  g_printerr("### %i \n", xnote->last_change_date);

  GList *tags = note->tags;
  while (tags != NULL) {
	  g_printerr("TAG %s \n", (gchar*)tags->data);
	  tags = tags->next;
  }
  */
  /*********/

  gtk_main();

  cleanup();

  /* Deinitialize OSSO */
  osso_deinitialize(osso_context);

  return 0;
}

