/* This file is part of Conboy.
 *
 * Copyright (C) 2009 Cornelius Hald
 *
 * Conboy is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Conboy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Conboy. If not, see <http://www.gnu.org/licenses/>.
 */


/* Includes */
#include <hildon/hildon-program.h>
#include <hildon/hildon-window.h>
#include <gtk/gtkmain.h>
#include <glib/gstdio.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>
#include <libosso.h>
#include <string.h>
#include <stdlib.h>

#include <libxml/xmlreader.h>

#include <libxml/encoding.h>
#include <libxml/xmlwriter.h>

#include <stdio.h>

#ifndef __USE_XOPEN
#define __USE_XOPEN
#endif
#include <time.h>

#include "metadata.h"
#include "interface.h"
#include "callbacks.h"
#include "note.h"

#include "search_window.h"

#include "note_list_store.h"

#include "localisation.h"

#include "../config.h"


#define APP_NAME "conboy"
/*#define APP_VER "0.3.1"*/
#define APP_SERVICE "de.zwong.conboy"
#define APP_METHOD "/de/zwong/conboy"

#define MY_ENCODING "utf-8"

#ifdef HAVE_MIDGARD

MidgardConnection *mgd = NULL;
static void conboy_midgard_init(void);


static void conboy_midgard_init(void)
{
	MidgardConfig *config;
	guint n_types;
	guint i;
	const gchar *typename;
	GType *all_types;
	MidgardObjectClass *klass;
	GError *error;

	/* Initialize Midgard type system */
	midgard_init();

	/* Initialize configuration */
	g_print("Initialize midgard_config \n");
	config = midgard_config_new();
	g_object_set(config,
			"dbtype", "SQLite",
			"database", "ConboyMidgard",
			"loglevel", "message",
			NULL);

	error = NULL;
	/* Store configuration in user's directory */
	g_print("Save configuration file \n");
	if (!midgard_config_save_file(config, "Conboy", TRUE, &error))
		g_error("Failed to store Midgard configuration file. %s", error && error->message ? error->message : "");
	
	if (error) 
		g_error_free(error);

	error = NULL;
	/* Workaround core bug, recreate defaults */
	g_print("Read configuration file \n");
	if (!midgard_config_read_file(config, "Conboy", TRUE, &error))
		g_error("Failed to read Midgard configuration file. %s", error && error->message ? error->message : "");

	if (error)
		g_error_free(error);

	/* Initialize connection and connect to database */
	g_print("Initialize new midgard_connection \n");
	mgd = midgard_connection_new();

	g_print("Open database connection \n");
	if (!midgard_connection_open_config(mgd, config))
		g_error("Failed to connect to Midgard database");

	/* Make sure we have database layout ready to use */
	g_print("Create midgard basic tables \n");
	midgard_config_create_midgard_tables(config, mgd);

	/* Create database tables for user defined MgdSchema classes */
 	all_types = g_type_children(MIDGARD_TYPE_OBJECT, &n_types);

	for (i = 0; i < n_types; i++) {
		
		typename = g_type_name(all_types[i]);
		klass = MIDGARD_OBJECT_GET_CLASS_BY_NAME(typename);

		g_print("Create midgard table for %s class \n", typename);
		midgard_config_create_class_table(config, klass, mgd);
	}
}
#endif


int
main (int argc, char *argv[])
{
  HildonProgram *program;
  Note *note;
  osso_context_t *osso_context;
  AppData *app_data;

  /* Init GTK */
  /*gtk_init(&argc, &argv);*/

#ifdef HILDON_HAS_APP_MENU
  g_printerr("HILDON INIT \n");
  hildon_gtk_init(&argc, &argv);
#else
  gtk_init(&argc, &argv);
#endif

#ifdef HAVE_MIDGARD
	conboy_midgard_init();
#endif	

  /* Call this to initialize it */
  app_data = get_app_data();

  /* Initialize maemo application */
  g_printerr("Starting %s, Version %s \n", APP_NAME, VERSION);
  osso_context = osso_initialize(APP_SERVICE, VERSION, TRUE, NULL);

  /* Check that initialization was ok */
  if (osso_context == NULL) {
      return OSSO_ERROR;
  }

  /* Create the Hildon program and setup the title */
  program = HILDON_PROGRAM(hildon_program_get_instance());
  g_set_application_name("Conboy");

  /* Get the most recent note. If there is none, create new. */
  note = note_list_store_get_latest(app_data->note_store);
  if (note == NULL) {

	  note = note_create_new();
  }

  note_show(note);

  gtk_main();

  /* Deinitialize OSSO */
  osso_deinitialize(osso_context);

  return 0;
}

