/*
* Copyright (C) 2008-2010 J-P Nurmi jpnurmi@gmail.com
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* $Id$
*/

#include "settings.h"
#include <QApplication>

Settings::Settings() : maxBlockCount(-1)
{
#if defined(Q_WS_MAEMO_5)
    shortcuts[TabUp] = QApplication::translate("Shortcuts", "Shift+Backspace");
    shortcuts[TabDown] = QApplication::translate("Shortcuts", "Shift+Enter");
    shortcuts[TabLeft] = QApplication::translate("Shortcuts", "Shift+Left");
    shortcuts[TabRight] = QApplication::translate("Shortcuts", "Shift+Right");
#elif defined(Q_WS_MAC)
    shortcuts[TabUp] = QApplication::translate("Shortcuts", "Ctrl+Up");
    shortcuts[TabDown] = QApplication::translate("Shortcuts", "Ctrl+Down");
    shortcuts[TabLeft] = QApplication::translate("Shortcuts", "Ctrl+Left");
    shortcuts[TabRight] = QApplication::translate("Shortcuts", "Ctrl+Right");
#else
    shortcuts[TabUp] = QApplication::translate("Shortcuts", "Alt+Up");
    shortcuts[TabDown] = QApplication::translate("Shortcuts", "Alt+Down");
    shortcuts[TabLeft] = QApplication::translate("Shortcuts", "Alt+Left");
    shortcuts[TabRight] = QApplication::translate("Shortcuts", "Alt+Right");
#endif // Q_WS_XXX

    messages[Joins] = true;
    messages[Parts] = true;
    messages[Nicks] = true;
    messages[Modes] = true;
    messages[Kicks] = true;
    messages[Quits] = true;
    messages[Topics] = true;

    highlights[Joins] = false;
    highlights[Parts] = false;
    highlights[Nicks] = false;
    highlights[Modes] = false;
    highlights[Kicks] = false;
    highlights[Quits] = false;
    highlights[Topics] = false;

    // TODO: the default values should respect palette
    colors[Background] = "white";
    colors[Message] = "black";
    colors[Event] = "steelblue";
    colors[Notice] = "brown";
    colors[Action] = "darkmagenta";
    colors[Highlight] = "red";

    aliases["j"] = "join $1 $2";
    aliases["me"] = "action $*";
    aliases["msg"] = "privmsg $*";
    aliases["op"] = "mode $? +o $*";
    aliases["deop"] = "mode $? -o $*";
    aliases["ban"] = "mode $? +b $*";
    aliases["unban"] = "mode $? -b $*";
    aliases["voice"] = "mode $? +v $*";
    aliases["devoice"] = "mode $? -v $*";
}

Settings::operator QVariant() const
{
    return QVariant::fromValue(*this);
}

bool Settings::operator==(const Settings& other) const
{
    return messages == other.messages && highlights == other.highlights
        && colors == other.colors && aliases == other.aliases
        && language == other.language && font == other.font
        && shortcuts == other.shortcuts && maxBlockCount == other.maxBlockCount;
}

bool Settings::operator!=(const Settings& other) const
{
    return !(*this == other);
}
