/*
* Copyright (C) 2008-2010 J-P Nurmi jpnurmi@gmail.com
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* $Id$
*/

#include "session.h"
#include <QApplication>
#ifndef QT_NO_OPENSSL
#include <QSslSocket>
#endif // QT_NO_OPENSSL

Session::Session(QObject* parent) : Irc::Session(parent)
{
    setAutoReconnectDelay(10);
    //setOptions(options() | Session::PrefixNicks);
}

Connection Session::connection() const
{
    return conn;
}

void Session::connectTo(const Connection& connection)
{
#ifndef QT_NO_OPENSSL
    if (connection.secure)
    {
        QSslSocket* socket = new QSslSocket(this);
        socket->setPeerVerifyMode(QSslSocket::VerifyNone);
        socket->ignoreSslErrors();
        setSocket(socket);
    }
#endif // QT_NO_OPENSSL
    
    QString appName = QApplication::applicationName();

    setNick(connection.nick);
    setIdent(appName.toLower());
    setRealName(connection.real.isEmpty() ? appName : connection.real);
    setPassword(connection.pass);
    
    connectToServer(connection.host, connection.port);

    conn = connection;
}
