/*
* Copyright (C) 2008-2010 J-P Nurmi jpnurmi@gmail.com
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* $Id$
*/

#include "hometabwidget.h"
#include "connectionspage.h"
#include "welcomepage.h"

HomeTabWidget::HomeTabWidget(QWidget* parent) : TabWidget(parent)
{
    addTab(new WelcomePage(this), tr("Welcome"));
    addTab(new ConnectionsPage(this), tr("Connections"));

    connect(widget(1), SIGNAL(connectTo(Connection)), SIGNAL(connectTo(Connection)));
    connect(this, SIGNAL(currentChanged(int)), this, SLOT(tabActivated(int)));

#if !defined(Q_WS_MAC) && !defined(Q_WS_MAEMO_5)
    QToolButton* settingsButton = new QToolButton(this);
    connect(settingsButton, SIGNAL(clicked()), qApp, SLOT(showSettings()));
    settingsButton->setIcon(QPixmap(":/resources/oxygen/16x16/actions/configure.png"));
    setCornerWidget(settingsButton);
#endif // !Q_WS_MAC && !Q_WS_MAEMO_5

#if QT_VERSION >= 0x040600
    registerSwipeGestures(Qt::Horizontal);
#endif
}

void HomeTabWidget::tabActivated(int index)
{
    window()->setWindowFilePath(tabText(index));
}
