/*
* Copyright (C) 2008-2010 J-P Nurmi jpnurmi@gmail.com
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* $Id$
*/

#ifndef CONNECTIONSPAGE_H
#define CONNECTIONSPAGE_H

#include "ui_connectionspage.h"
#include "connection.h"

class ConnectionsPage : public QWidget
{
    Q_OBJECT

public:
    ConnectionsPage(QWidget* parent = 0);

signals:
    void connectTo(const Connection& connection);

private slots:
    void addConnection();
    void editConnection();
    void removeConnection();
    void connectTo(QTreeWidgetItem* item);

    void updateConnections(const Connections& connections);
    void updateUi();

private:
    Ui::ConnectionsPage ui;
};

#endif // CONNECTIONSPAGE_H
