#include "RouteListDelegate.h"

#include <QtGui>

class RouteListDelegatePrivate
{
public:
    RouteListDelegatePrivate();
};

RouteListDelegatePrivate::RouteListDelegatePrivate()
{ /* ... */ }

RouteListDelegate::RouteListDelegate(QObject *parent)
    : QStyledItemDelegate(parent),
      d(new RouteListDelegatePrivate)
{
}

RouteListDelegate::~RouteListDelegate()
{
    delete this->d;
}

void RouteListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    const QRect rect = option.rect;

    bool isCurrent = false;

    QString name = tr("RT#20110118");

    QColor cNormal = (isCurrent ? option.palette.foreground() : option.palette.highlight()).color();
    QColor cAttrib = (isCurrent ? option.palette.mid() : option.palette.highlight()).color();

    QFont fNormal = QFont(painter->font());
    fNormal.setPointSize(18);

    QFont fSmall  = QFont(painter->font());
    fSmall.setPointSize(14);

    if(option.state & QStyle::State_On)
    {
        painter->fillRect(rect, option.palette.highlight());
    }

    painter->setPen(QPen(cNormal));
    painter->setFont(fNormal);

    QRect bRect1 = painter->boundingRect(rect.x(), rect.y(), 0, 0, 0, name);
}
