#ifndef APPLICATIONSTATUSVIEW_H
#define APPLICATIONSTATUSVIEW_H

#include "ApplicationView.h"

#include <QLabel>

class ColumbusStatusViewPrivate;

class ColumbusStatusView : public ApplicationView
{
    Q_OBJECT

public:
    explicit                 ColumbusStatusView (QWidget *parent = 0);
                            ~ColumbusStatusView ();

    QString                  friendlyName       () const;

    ApplicationController*      controller         () const;
    void                     setController      (ApplicationController *controller);

protected:
    bool         eventFilter(QObject *object, QEvent *event);

private slots:
    void         onLandscape                ();
    void         onPortrait                 ();

    void         onPositionUpdated          (const QGeoPositionInfo &posinfo);

private:
    QLabel*      ValueLabel     (const QString &text) const;

    ColumbusStatusViewPrivate *d;
};

#endif // APPLICATIONSTATUSVIEW_H
