#include "ColumbusDialogTools.h"
#include "ColumbusDialogLogging.h"

#include <rx/columbus/ColumbusController.h>
#include <rx/columbus/logging/FileLoggerConfig.h>

#include <QtGui>
#include <QtMaemo5>

class ColumbusDialogToolsPrivate
{
public:
    ColumbusDialogToolsPrivate();

    ColumbusDialogLogging *lDialog;
    QMaemo5ValueButton *lControl;
};

ColumbusDialogToolsPrivate::ColumbusDialogToolsPrivate()
{ /* ... */ }

ColumbusDialogTools::ColumbusDialogTools(QWidget *parent)
    : ColumbusDialog(parent), d(new ColumbusDialogToolsPrivate)
{
    new QVBoxLayout(this);

    this->setWindowTitle(tr("Tools"));

    d->lDialog = new ColumbusDialogLogging(this);
    d->lControl = new QMaemo5ValueButton(tr("File Logging"), this);

    this->layout()->addWidget(d->lControl);

    QObject::connect(d->lControl, SIGNAL(clicked()), d->lDialog, SLOT(show()));
}

ColumbusDialogTools::~ColumbusDialogTools()
{
    delete this->d;
}

void ColumbusDialogTools::setController(ApplicationController *controller)
{
    ColumbusDialog::setController(controller);

    if(controller == NULL)
    {
        QObject::disconnect(d->lDialog, SIGNAL(finished(int)), this, SLOT(onDialogFinished()));
    }

    QList<QString> ids = controller->plugins()->plugins().keys();
    qSort(ids);

    foreach(QString id, ids)
    {
        ColumbusPluginInterface *plugin = controller->plugins()->plugins().value(id);
        QWidget *control = plugin->control();

        if(control != NULL)
        {
            control->setParent(this);
            if(control != NULL) this->layout()->addWidget(control);
        }
    }

    d->lDialog->setController(controller);
    this->onDialogFinished();

    QObject::connect(d->lDialog, SIGNAL(finished(int)), this, SLOT(onDialogFinished()));
}

void ColumbusDialogTools::onDialogFinished()
{
    FileLoggerConfig config;

    if(config.isEnabled())
    {
        d->lControl->setValueText("Enabled");
    }
    else
    {
        d->lControl->setValueText("Disabled");
    }
}
