#include "ApplicationController.h"
#include "ColumbusRouteModel.h"

#include "config.h"

#include <QDebug>
#include <QSqlDatabase>

class ApplicationControllerPrivate
{
public:
    ColumbusRouteModel *routes;
};

ApplicationController::ApplicationController(QObject *parent)
    : ColumbusController(parent)
{
    this->d = new ApplicationControllerPrivate;
    this->setupConfig();

    d->routes = new ColumbusRouteModel(this, this->database());
}

ApplicationController::~ApplicationController()
{
    delete this->d;
}

void ApplicationController::setupConfig()
{
    qDebug() << "ApplicationController: Initializing UI configuration structure.";
    this->config()->prependOption(CONFIG_KEY_DISPLAY_ORIENTATION, tr("Orientation"),
                                  QStringList() << tr("Automatic") << tr("Landscape") << tr("Portrait"));

    this->config()->prependToggle(CONFIG_KEY_DISPLAY_KEEP_ALIVE, tr("Keep-Alive Backlight"), true);
}
