#ifndef ABSTRACTCOMPASS_H
#define ABSTRACTCOMPASS_H

#include <QWidget>

class AbstractCompassPrivate;

class AbstractCompass : public QWidget
{
    Q_OBJECT

    Q_PROPERTY(double heading READ heading WRITE setHeading NOTIFY headingChanged)
    Q_PROPERTY(double bearing READ bearing WRITE setBearing NOTIFY bearingChanged)
    Q_PROPERTY(bool isBearingShown READ isBearingShown WRITE setBearingShown NOTIFY bearingShownChanged)

public:
    explicit     AbstractCompass    (QWidget *parent = 0);
                ~AbstractCompass    ();

    double       heading            () const;
    double       bearing            () const;
    bool         isBearingShown     () const;

signals:
    void         headingChanged     (double heading);
    void         bearingChanged     (double bearing);
    void         bearingShownChanged(bool isShown);

public slots:
    void         setHeading         (double heading);
    void         setBearing         (double bearing);
    void         setBearingShown    (bool isShown);

protected:
    virtual void paintEvent         (QPaintEvent *event) = 0;

    AbstractCompassPrivate *d;
};

#endif // ABSTRACTCOMPASS_H
