#ifndef APPLICATIONTRACKVIEW_H
#define APPLICATIONTRACKVIEW_H

#include "ApplicationView.h"

#include <QLabel>
#include <QHBoxLayout>
#include <QPropertyAnimation>

class ColumbusTrackViewPrivate;

class ColumbusTrackView : public ApplicationView
{
    Q_OBJECT

public:
    explicit ColumbusTrackView  (QWidget *parent = 0);
            ~ColumbusTrackView  ();

    QString  friendlyName   () const;
    void     setController  (ApplicationController *controller);

public slots:
    void     cycleSpeedIndicator    ();

private slots:
    void onDistanceUpdated  (qreal);
    void onPositionUpdated  (const QGeoPositionInfo &posinfo);

protected:
    void resizeEvent    (QResizeEvent *event);
    bool eventFilter    (QObject *object, QEvent *event);
    void keyPressEvent  (QKeyEvent *event);

private:
    QLabel*  ValueLabel (const QString &value) const;

    ColumbusTrackViewPrivate *d;
};

#endif // APPLICATIONTRACKVIEW_H
