#ifndef COLUMBUSDIALOGWAYPOINTS_H
#define COLUMBUSDIALOGWAYPOINTS_H

#include "widgets/ColumbusDialog.h"

class ColumbusDialogWaypointsPrivate;

class ColumbusDialogWaypoints : public ColumbusDialog
{
    Q_OBJECT

public:
    explicit ColumbusDialogWaypoints(QWidget *parent = 0);
            ~ColumbusDialogWaypoints();

    void setController(ApplicationController *controller);

protected slots:
    void setupUi();
    void updateUi();

    void onWaypointSelected(const QModelIndex &index);
    void onNavigateTo();
    void onClearDestination();

    void showCreateForm();
    void showUpdateForm();
    void showAverageDialog();
    void showDeleteConfirmation();

    void onFormCreateFinished(int result);
    void onFormUpdateFinished(int result);
    void onDeleteConfirmation(int result);

private:
    ColumbusDialogWaypointsPrivate *d;
};

#endif // COLUMBUSDIALOGWAYPOINTS_H
