#include "math.h"
#include "SatelliteCompassDial.h"

class SatelliteCompassDialPrivate
{
public:
    QList<int>                      satsInUse;
    QHash<int,QGeoSatelliteInfo>    satsInView;
};

SatelliteCompassDial::SatelliteCompassDial(QWidget *parent)
    : CompassDial(parent)
{
    this->d = new SatelliteCompassDialPrivate;
}

SatelliteCompassDial::~SatelliteCompassDial()
{
    delete this->d;
}

void SatelliteCompassDial::setSatsInUse(const QList<QGeoSatelliteInfo> &sats)
{
    d->satsInUse.clear();

    foreach(QGeoSatelliteInfo satinfo, sats)
    {
        d->satsInUse.append(satinfo.prnNumber());
    }

    this->update();
}

void SatelliteCompassDial::setSatsInView(const QList<QGeoSatelliteInfo> &sats)
{
    d->satsInView.clear();

    foreach(QGeoSatelliteInfo satinfo, sats)
    {
        d->satsInView.insert(satinfo.prnNumber(), satinfo);
    }

    this->update();
}

void SatelliteCompassDial::draw(QPainter *painter)
{
    const int size  = qMin(this->width(), this->height()) - 10;
    const int hsize = size / 2;

    const int c  = size * 0.03; // Indicator diameter.
    const int r = c / 2; // Indicator radius.

    CompassDial::draw(painter);

    painter->setPen(QPen(this->palette().foreground(), 1.0f));

    foreach(int prn, d->satsInView.keys())
    {
        QGeoSatelliteInfo satinfo = d->satsInView.value(prn);

        qreal azimuth   = satinfo.attribute(QGeoSatelliteInfo::Azimuth);
        qreal elevation = cos(satinfo.attribute(QGeoSatelliteInfo::Elevation) * M_PI / 180);

        painter->setMatrix(QMatrix());
        painter->rotate(-this->heading() + azimuth);
        painter->translate(0, elevation * hsize);

        if(d->satsInUse.contains(prn))
        {
            painter->setBrush(this->palette().foreground());
        }
        else
        {
            painter->setBrush(this->palette().background());
        }

        painter->drawEllipse(-r, -r, c, c);
    }
}
