#ifndef APPLICATIONSTATUSVIEW_H
#define APPLICATIONSTATUSVIEW_H

#include "ApplicationView.h"

#include <QString>
#include <QLabel>

class ColumbusStatusViewPrivate;

class ColumbusStatusView : public ApplicationView
{
    Q_OBJECT

public:
    explicit                 ColumbusStatusView (QWidget *parent = 0);
                            ~ColumbusStatusView ();

    QString                  friendlyName       () const;

    ColumbusController*      controller         () const;
    void                     setController      (ColumbusController *controller);

private slots:
    void         onLandscape                ();
    void         onPortrait                 ();

    void         onPositionUpdated          (const QGeoPositionInfo &posinfo);

private:
    QLabel*      ValueLabel     (const QString &text) const;

    ColumbusStatusViewPrivate *d;
};

#endif // APPLICATIONSTATUSVIEW_H
