#ifndef PLUGININTERFACE_H
#define PLUGININTERFACE_H

#include <QObject>
#include <QWidget>

class PluginManager;

class ColumbusPlugin : public QObject
{
    Q_OBJECT

    Q_PROPERTY(QString id READ id)
    Q_PROPERTY(QString version READ version)
    Q_PROPERTY(QString friendlyName READ friendlyName)

public:
    explicit ColumbusPlugin         (QObject *parent = 0) : QObject(parent) {}
    virtual ~ColumbusPlugin         () {};

    virtual QString id              () const = 0;
    virtual QString version         () const = 0;
    virtual QString friendlyName    () const = 0;

    virtual QWidget* control        () {return NULL;}

    virtual bool initialize         (PluginManager *manager) = 0;
};

#endif // PLUGININTERFACE_H
