#include "CompassDial.h"
#include "CompassPrivate.h"

CompassDial::CompassDial(QWidget *parent)
    : AbstractCompass(parent)
{
    QSizePolicy policy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    policy.setHeightForWidth(true);
    this->setSizePolicy(policy);
}

int CompassDial::heightForWidth(int width) const
{
    return width;
}

void CompassDial::paintEvent(QPaintEvent*)
{
    QPainter    painter(this);

    const int width   = this->width();
    const int height  = this->height();

    const int size    = qMin(width, height);
    const int hsize   = size / 2;

    // Setup viewport.
    painter.setRenderHint(QPainter::Antialiasing, true);
    painter.setViewport((width - size) / 2, (height - size) / 2, size, size);
    painter.setWindow(-hsize, -hsize, size, size);

    // Draw dial.
    painter.setMatrix(QMatrix());
    painter.rotate(-this->heading());
    this->draw(&painter);
}

void CompassDial::draw(QPainter *painter)
{
    // Viewport dimensions.
    const int width     = this->width();
    const int height    = this->height();
    const int size      = qMin(width, height);
    const int hsize     = size / 2;

    // Radius values for compass rings.
    const int y1 = hsize - 1;
    const int y2 = (y1 / 3) * 2;
    const int y3 = (y1 / 3);

    // Length values for compass spokes.
    const int d90   = size * 0.07;
    const int d45   = size * 0.04;
    const int d5    = size * 0.03;
    const int d1    = size * 0.02;

    QPen   p125    (this->palette().foreground(), 0.5f);
    QPen   p250    (this->palette().foreground(), 1.0f);

    QFont  f5pt    ("Times");
    QFont  f7pt    ("Times");

    f5pt.setPixelSize((y1 - y2) / 3);
    f7pt.setPixelSize((y1 - y2) / 2);

    painter->setPen(p250);
    //painter->setBrush(g1);
    painter->drawEllipse(-y1, -y1, y1 * 2, y1 * 2);

    painter->setPen(p125);
    //painter->setBrush(g2);
    painter->drawEllipse(-y2, -y2, y2 * 2, y2 * 2);

    painter->setPen(p125);
    //painter->setBrush(g3);
    painter->drawEllipse(-y3, -y3, y3 * 2, y3 * 2);

    const int xSize = size * 0.05f;

    painter->drawLine( 0, -xSize,  0, xSize);
    painter->drawLine(-xSize,  0,  xSize, 0);

    // Draw dial.
    painter->setBrush(this->palette().foreground());
    for(int i = 0; i < 360; i++)
    {
        int v = d5;

        if (i % 90 == 0)
        {
            const char  *point  = CompassPoints[i / 45];

            painter->setPen(p250);
            painter->setFont(f7pt);
            painter->drawText(
                    painter->boundingRect(0, -y1 + f7pt.pixelSize() * 1.25, 0, 0, Qt::AlignCenter|Qt::AlignVCenter, point),
                    Qt::AlignHCenter|Qt::AlignVCenter, point);

            v = d90;
        }
        else if (i % 45 == 0)
        {
            const char  *point  = CompassPoints[i / 45];

            painter->setPen(p250);
            painter->setFont(f5pt);
            painter->drawText(
                    painter->boundingRect(0, -y1 + f5pt.pixelSize() * 2, 0, 0, Qt::AlignCenter|Qt::AlignVCenter, point),
                    Qt::AlignHCenter|Qt::AlignVCenter, point);

            v = d45;
        }

        if (i % 5 == 0)
        {
            painter->setPen(p250);
            painter->drawLine(0, y1, 0, y1 + -v);

            painter->setPen(p250);
            painter->drawLine(0, y2, 0, y2 + -v / 2);

            painter->setPen(p125);
            painter->drawLine(0, y3, 0, y3 + -v / 2);
        }

        painter->setPen(p125);
        painter->drawLine(0, y1, 0, y1 + -d1);

        painter->rotate(1);
    }
}
