#ifndef MAEMO5MENUBUTTON_H
#define MAEMO5MENUBUTTON_H

#include <QApplication>

#include <QEvent>
#include <QMenuBar>
#include <QMainWindow>
#include <QToolButton>

#include <X11/Xlib.h>
#include <QX11Info>

class Maemo5MenuButton : public QToolButton
{
    Q_OBJECT

public:
    explicit inline Maemo5MenuButton (QMainWindow *parent) : QToolButton(parent)
    {
        QPalette palette = this->palette();
        palette.setColor(this->backgroundRole(), QColor(0, 0, 0, 96));
        this->setPalette(palette);

        this->setIcon(QIcon::fromTheme("call_more_options"));
        this->setFixedSize(this->sizeHint());
        this->setStyleSheet("QToolButton:pressed {border: none}");
        this->setAutoFillBackground(true);

        parent->installEventFilter(this);
        QObject::connect(this, SIGNAL(clicked()), this, SLOT(showMenu()));
    }

protected slots:
    inline void showMenu()
    {
        XEvent  xevent;

        xevent.xclient.format       = 32;
        xevent.xclient.message_type = XInternAtom(QX11Info::display(), "_MB_GRAB_TRANSFER", false);

        ((QApplication*)QApplication::instance())->x11ClientMessage(this->parentWidget(), &xevent, false);
    }

protected:
    inline bool eventFilter(QObject *object, QEvent *event)
    {
        if(object == this->parent() && event->type() == QEvent::Resize)
        {
            QMainWindow *parent     = (QMainWindow*)this->parentWidget();

            bool         isFull     = parent->windowState() & Qt::WindowFullScreen;
            bool         hasMenu    = !parent->menuBar()->actions().isEmpty();
            bool         isShown    = isFull && hasMenu;

            this->move(parent->width()  - this->width(), 0);
            this->setVisible(isShown);
            this->raise();
        }

        return QToolButton::eventFilter(object, event);
    }
};

#endif // MAEMO5MENUBUTTON_H
