#include <QDebug>

#include <QPainter>
#include "AccuracyGraph.h"

class AccuracyGraphPrivate
{
public:
    TripModel *model;
};

AccuracyGraph::AccuracyGraph(QWidget *parent)
    : AbstractChart(parent)
{
    QSizePolicy policy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    policy.setHeightForWidth(true);
    this->setSizePolicy(policy);

    this->setLabel(tr("Accuracy Graph"));

    this->d = new AccuracyGraphPrivate;
    d->model = NULL;
}

AccuracyGraph::~AccuracyGraph()
{
    delete this->d;
}

void AccuracyGraph::setModel(TripModel *model)
{
    d->model = model;
    this->update();
}

void AccuracyGraph::paintEvent(QPaintEvent*)
{
    const int w = this->width();
    int h = this->height() - 1;

    QPainter painter(this);
    painter.setRenderHint(QPainter::Antialiasing, true);
    painter.setPen(QPen(QColor(0xff, 0xff, 0xff), 1.0f));
    painter.setFont(QFont(painter.font().family(), 10));

    QRect rect = painter.boundingRect(0, 0, 0, 0, 0, this->label());
    painter.drawText(w / 2 - (rect.width() / 2), h - rect.height(), rect.width(), rect.height(), 0, this->label());

    h = h - rect.height() - 2;

    QColor sColor = this->palette().foreground().color();
    painter.setPen(QPen(sColor, 0.5f));

    int m = 12;
    for(int i = 1; i < m; i++)
    {
        painter.drawLine(0, (h / m) * i + h % m, w, (h / m) * i  + h % m);
    }

    painter.setPen(QPen(this->palette().foreground(), 1.00f));
    painter.drawLine(0, h, w, h);

    painter.setPen(QPen(this->palette().foreground(), 1.00f));
    if(d->model != NULL && d->model->datalog()->count() > 0)
    {
        const int rCount = d->model->datalog()->count();

        qreal phdop = d->model->datalog()->first().attribute(QGeoPositionInfo::HorizontalAccuracy);

        for(int i = qMin(rCount, w); i > 0; i--)
        {
            qreal hdop = d->model->datalog()->value(rCount - 1 - i).attribute(QGeoPositionInfo::HorizontalAccuracy);

            QPoint a(w - i, h - ((h / 500.0f) * hdop));
            QPoint b(w - i - 1, h - ((h / 500.0f) * phdop));

            painter.drawLine(a, b);
            phdop = hdop;
        }
    }
}
