#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "widgets/Maemo5Dialog.h"

#include "ApplicationController.h"
#include "ApplicationViewSwitcher.h"

#include <QMainWindow>

#include <QActionGroup>
#include <QSystemScreenSaver>
#include <QParallelAnimationGroup>

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit     MainWindow     (QWidget *parent = 0);

    void         initialize     (ApplicationController *controller);

signals:
    void         onLandscape    ();
    void         onPortrait     ();

    void         uiSuspended    ();
    void         uiResumed      ();

public slots:
    void         setOrientationAuto         (bool on = true);
    void         setOrientationLandscape    (bool on = true);
    void         setOrientationPortrait     (bool on = true);

    void         setScreenSaverInhibit      (bool on = true);

    void         showFullScreenControls     ();
    void         hideFullScreenControls     ();

private slots:
    void         resized    ();

    void         suspend    ();
    void         resume     ();

    void         onScreenLockSignal     (const QString &state);

    void         onViewChanged          (int view);
    void         onViewsActionSelected  (QAction *action);

    void         onConfigUpdated        (const QString &key, QVariant value);

protected:
    void         setupX11Keys();

private:
    void         setupMenu      ();
    void         setupViews     ();
    void         setupPalettes  ();

    bool         eventFilter    (QObject *object, QEvent *event);

    // Reference to application controller instance.
    ApplicationController   *m_Controller;
    ApplicationController   *m_ControllerSuspended;

    // Current screen lock state
    QString m_ScreenLockState;

    // Reference to object for inhibiting screen lock.
    QSystemScreenSaver      *m_ScreenSaver;

    // Custom palettes.
    QPalette         m_Theme;

    // Menu group for selecting views.
    QActionGroup    *m_ViewsActionGroup;

    // Application dialogs.
    Maemo5Dialog    *m_WaypointsDialog;
    Maemo5Dialog    *m_LoggingDialog;
    Maemo5Dialog    *m_OptionsDialog;
    Maemo5Dialog    *m_ToolsDialog;

    // View manager/switcher widget.
    ApplicationViewSwitcher *m_ApplicationViewSwitcher;

    // Animation for fullscreen controls.
    QParallelAnimationGroup *m_ControlsAnimationGroup;
};

#endif // MAINWINDOW_H
