#include "USBSerialConfig.h"

#include <QSettings>

#define CONFIG_KEY_USB_SERIAL_IS_ENABLED        "/plugins/usb-serial/enable"
#define CONFIG_KEY_USB_SERIAL_IS_RUN_ON_STARTUP "/plugins/usb-serial/startup"
#define CONFIG_KEY_USB_SERIAL_PORT_NUMBER       "/plugins/usb-serial/port"
#define CONFIG_KEY_USB_SERIAL_FORMAT            "/plugins/usb-serial/format"

USBSerialConfig::USBSerialConfig(QObject *parent) : QObject(parent) {/* ... */}

bool USBSerialConfig::isEnabled() const
{
    return QSettings().value(CONFIG_KEY_USB_SERIAL_IS_ENABLED, false).toBool();
}

bool USBSerialConfig::isRunOnStartup() const
{
    return QSettings().value(CONFIG_KEY_USB_SERIAL_IS_RUN_ON_STARTUP, false).toBool();
}

int USBSerialConfig::portNumber() const
{
    return QSettings().value(CONFIG_KEY_USB_SERIAL_PORT_NUMBER, 0).toInt();
}

QString USBSerialConfig::formatId() const
{
    return QSettings().value(CONFIG_KEY_USB_SERIAL_FORMAT, "nmea").toString();
}

void USBSerialConfig::setEnabled(bool on)
{
    QSettings().setValue(CONFIG_KEY_USB_SERIAL_IS_ENABLED, on);
}

void USBSerialConfig::setRunOnStartup(bool on)
{
    QSettings().setValue(CONFIG_KEY_USB_SERIAL_IS_RUN_ON_STARTUP, on);
}

void USBSerialConfig::setPortNumber(int number)
{
    QSettings().setValue(CONFIG_KEY_USB_SERIAL_PORT_NUMBER, number);
}

void USBSerialConfig::setFormatId(const QString &formatId)
{
    QSettings().setValue(CONFIG_KEY_USB_SERIAL_FORMAT, formatId);
}
