#ifndef TCPNETWORKCONNECTOR_H
#define TCPNETWORKCONNECTOR_H

#include <QObject>
#include <QAbstractSocket>

#include "NetworkServiceProvider.h"
#include "plugins/generic-server/ServicePerformerFactory.h"

class TCPNetworkConnectorPrivate;

class TCPNetworkConnector : public NetworkServiceProvider
{
    Q_OBJECT
public:
    explicit TCPNetworkConnector(const QString &address, quint16 port, ServicePerformerFactory *factory, QObject *parent = 0);
            ~TCPNetworkConnector();

    bool initialize();

protected slots:
    void onSocketStateChanged(QAbstractSocket::SocketState state);

    void onConnect();
    void onDisconnect();

protected:
    void timerEvent(QTimerEvent *event);

private:
    TCPNetworkConnectorPrivate *d;
};

#endif // TCPNETWORKCONNECTOR_H
