#ifndef NETWORKSERVERCONFIG_H
#define NETWORKSERVERCONFIG_H

#include <QObject>

class NetworkServerConfigPrivate;

class NetworkServerConfig : public QObject
{
    Q_OBJECT
public:
    typedef enum {
        TransportUdp,
        TransportTcp
    } Transport;

    typedef enum {
        UdpUnicast,
        UdpMulticast
    } UdpConnectionType;

    typedef enum {
        TcpClient,
        TcpServer
    } TcpConnectionType;

    explicit NetworkServerConfig(QObject *parent = 0);
            ~NetworkServerConfig();

    bool operator == (const NetworkServerConfig &other);
    bool operator != (const NetworkServerConfig &other);

    bool                 isEnabled() const;
    bool                 isRunOnStartup() const;
    Transport            transport() const;

    UdpConnectionType    udpConnectionType() const;
    QString              udpUnicastAddress() const;
    quint16              udpUnicastPort() const;
    QString              udpMulticastAddress() const;
    quint16              udpMulticastPort() const;

    TcpConnectionType    tcpConnectionType() const;
    QString              tcpClientAddress() const;
    quint16              tcpClientPort() const;
    QString              tcpServerAddress() const;
    quint16              tcpServerPort() const;

    QString              formatId() const;

public slots:
    void load();
    void save();

    void setEnabled(bool isEnabled);
    void setRunOnStartup(bool isRunOnStartup);

    void setTransport(Transport transport);

    void setUdpConnectionType(UdpConnectionType connectionType);
    void setUdpUnicastAddress(const QString &address);
    void setUdpUnicastPort(quint16 port);
    void setUdpMulticastAddress(const QString &address);
    void setUdpMulticastPort(quint16 port);

    void setTcpConnectionType(TcpConnectionType connectionType);
    void setTcpClientAddress(const QString &address);
    void setTcpClientPort(quint16 port);
    void setTcpServerAddress(const QString &address);
    void setTcpServerPort(quint16 port);

    void setFormatId(const QString &formatId);

private:
    NetworkServerConfigPrivate *d;
};

#endif // NETWORKSERVERCONFIG_H
