#ifndef BLUETOOTHSERVERPLUGIN_H
#define BLUETOOTHSERVERPLUGIN_H

#include <QObject>
#include <rx/columbus/ColumbusPluginManager.h>

class BluetoothServerPluginPrivate;

class BluetoothServerPlugin : public QObject, public ColumbusPluginInterface
{
    Q_OBJECT
    Q_INTERFACES(ColumbusPluginInterface)

public:
    explicit BluetoothServerPlugin(QObject *parent = 0);
            ~BluetoothServerPlugin();

    QString id() const;
    QString version() const;

    QString friendlyName() const;

    QWidget* control();

    bool initialize(PluginManager *manager);

protected slots:
    bool startup();
    void shutdown();

    void onDialogFinished();

private:
    BluetoothServerPluginPrivate *d;
};

#endif // BLUETOOTHSERVERPLUGIN_H
