/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#ifndef VIRTUALKEYBOARD_H_
#define VIRTUALKEYBOARD_H_

#include "../gl.h"
#include <SDL/SDL.h>
#include <QtCore/QList>
#include "KeyboardLayout.h"

typedef enum {
	CHAR_KEY, SHIFT_KEY, LANGUAGE_KEY, BACKSPACE_KEY, ENTER_KEY
} KeyType;

typedef struct {
	GLfloat x, y, width;
	QString lowercase;
	QString lowercaseAlternate;
	QString uppercase;
	QString uppercaseAlternate;
	KeyType type;
} Key;

class VirtualKeyboard {
	bool uppercase;
	SDL_Surface* lowercaseSurface;
	SDL_Surface* lowercaseMask;
	SDL_Surface* uppercaseSurface;
	SDL_Surface* uppercaseMask;
	GLuint lowercaseTexture;
	GLuint lowercaseMaskTexture;
	GLuint uppercaseTexture;
	GLuint uppercaseMaskTexture;
	KeyboardLayout* currentLayout;
	QList<KeyboardLayout*>* layouts;
	void preRenderTexture(SDL_Surface **surface, SDL_Surface **maskSurface, bool uppercase);
	void initKeys();
	void createTextures();
	void deleteTextures();
	void renderBackgrounds();
	void handleKeyReleased(Key& key, int lastPressedKey, long lastPressedTime);
	void handleKeyHold(int pressedKey, int lastPressedKey, long lastPressedTime);
public:
	VirtualKeyboard();
	void render();
	bool isActive();
	int handleMouse();
	QList<KeyboardLayout*> * getLayouts();
	KeyboardLayout* getCurrentLayout();
	void setLayout(KeyboardLayout* layout);
	virtual ~VirtualKeyboard();
};

#endif /* VIRTUALKEYBOARD_H_ */
