#include "compass.h"

Compass::Compass()
{
	m_sensor.addFilter(this);
	m_sensor.start();
	if (m_sensor.isActive()) {
		options.hasCompass = TRUE;
		qDebug() << "Compass initialized";
	} else {
		qDebug() << "Compass sensor is not present" << endl;
		options.hasCompass = FALSE;
	}
}

bool Compass::filter(QCompassReading *reading)
{
	azimuth = reading -> azimuth();
	return true;
}

Compass::~Compass() {}

Compass* compassObj = NULL;

void initCompass() {
	compassObj	= new Compass();
}

double getCompassAzimuth() {
	return compassObj -> azimuth;
}
