/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#ifndef UIELEMENT_H_
#define UIELEMENT_H_

#include "../main.h"
#include "texture.h"
#include "glcanvas.h"
#include "console.h"
#include "taskman.h"
#include "../tile_engine/tileengine.h"

void loadUI();
int processUiMouse();
void updateUi();
UiElement* getPressedUiElem();
void drawUiElement(UiElement* elem);
void drawUiElems();
void drawZoomBar();
void drawSearchBar();
void drawStatusBar(Orientation orientation);

extern UiElement *crosshair, *zoomIn, *zoomOut, *position, *gotomypos, *view2d,
		*view3d, *compass, *search, *zoomKnot, *closeApp, *tasks;

#endif /* UIELEMENT_H_ */
