/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#include "AnimatedElement.h"
#include "AnimationManager.h"

TransitionState* emptyState = new TransitionState;

AnimatedElement::AnimatedElement() {
	current = emptyState;
	target = emptyState;
	paused = true;
	AnimationManager::addAnimation(this);
}

void AnimatedElement::setTargetState(TransitionState* target) {
	this -> target = target;
}

void AnimatedElement::setTransitionInCompleted(bool completed) {
	this -> transitionInCompleted = completed;
}

void AnimatedElement::setPaused(bool paused) {
	this -> paused = paused;
}

bool AnimatedElement::isPaused() {
	return this -> paused;
}

AnimatedElement::~AnimatedElement() {
	// TODO Auto-generated destructor stub
}
