/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#include "textRender.h"
#include "../animation/TransitionState.h"
#include "../animation/AnimatedElement.h"
#include "../animation/states/DialogText.h"

#define GLYPH_ATLAS_SIZE 512

typedef struct Glyph {
	int x, y, width, height; // position within texture atlas
	int tx, ty; // glyph translation on screen
} Glyph;

QHash<GLuint, Glyph*> *glyphs;

void addText(Point* pos, Color* color, int fontSize, char* utf8) {

}

int tmp_text_initialized = FALSE;
SDL_Surface *text_surface;
TTF_Font *smallFont;
TTF_Font *bigFont;
GLuint text_texture;

extern GLfloat quadStripVertices[12];
extern GLfloat texCoordsLandscape[][8];

void setQuadStripSize(GLfloat w, GLfloat h, GLfloat quad[12]);

int glyphSurfaceInitialized = FALSE;
SDL_Surface* glyphAtlas = NULL;
GLuint glyphAtlasTexture = 0;

void refreshGlyphAtlasTexture() {
	if (glyphAtlasTexture != 0) {
		glDeleteTextures(1, &glyphAtlasTexture);
	}
	glyphAtlasTexture = createTexture((GLushort*) glyphAtlas -> pixels, GLYPH_ATLAS_SIZE, GLYPH_ATLAS_SIZE, FALSE);
}

void initializeGlyphAtlas() {
	glyphAtlas = SDL_CreateRGBSurface(SDL_SWSURFACE, GLYPH_ATLAS_SIZE, GLYPH_ATLAS_SIZE, 16, 0x00000F000, 0x00000F00, 0x000000F0, 0x000000F);

	if (glyphAtlas == NULL) {
		fprintf(stderr, "Font render: memory allocation error\n");
		exit(1);
	}
	smallFont = TTF_OpenFont("/opt/cloudgps/res/nokia_pure.ttf", 18);
	if (!smallFont) {
		fprintf(stderr, "TTF_OpenFont error: %s\n", TTF_GetError());
		exit(1);
	}

	bigFont = TTF_OpenFont("/opt/cloudgps/res/nokia_pure.ttf", 26);
	if (!bigFont) {
		fprintf(stderr, "TTF_OpenFont error: %s\n", TTF_GetError());
		exit(1);
	}
	glyphs = new QHash<GLuint, Glyph*> ();
}

void initFonts() {
	if (TTF_Init() == -1) {
		fprintf(stderr, "TTF_Init: %s\n", TTF_GetError());
		exit(2);
	}
	initializeGlyphAtlas();
}

void renderText() {
	static int counter = 0;
	//	if (canvas.navigationStatus.currentDirection == NULL) {
	//		tmp_text_initialized = FALSE;
	//		return;
	//	}

	for (int i = 0; i < 10; i++) {
		int textSurfaceWidth = 512;
		int textSurfaceHeight = 32;

		if (!tmp_text_initialized) {
			//fprintf(stderr, "TTF test\n");

			char text[300];
			sprintf(text, "Zażółć gęślą jaźń größe %d", counter++);
			SDL_Color color = { 255, 255, 255 };
			text_surface = TTF_RenderUTF8_Blended(smallFont, text, color);
			//TTF_SizeUTF8();

			if (!text_surface) {
				fprintf(stderr, "TTF_RenderText_Blended failed: %s\n", TTF_GetError());
				return;
			}
			tmp_text_initialized = TRUE;
			SDL_Surface* tmpSurface = SDL_CreateRGBSurface(SDL_SWSURFACE, textSurfaceWidth, textSurfaceHeight, 16, 0x00000F000, 0x00000F00, 0x000000F0, 0x000000F);
			SDL_Rect rect;

			rect.x = 0;
			rect.y = 0;
			rect.w = text_surface->w;
			rect.h = text_surface->h;
			SDL_UpperBlit(text_surface, &rect, tmpSurface, &rect);
			glDeleteTextures(1, &text_texture);
			text_texture = createTexture((GLushort*) tmpSurface -> pixels, textSurfaceWidth, textSurfaceHeight, FALSE);
			SDL_FreeSurface(text_surface);
			SDL_FreeSurface(tmpSurface);
			//			fprintf(stderr, "text texture: %d\n", text_texture);

		}

		extern TransitionState* emptyState;
		static AnimatedElement textRenderElement;
		static DialogText dialogText;

		if (canvas.dimColor == 1.0) {
			textRenderElement.setTargetState(&dialogText);
		} else {
			textRenderElement.setTargetState(emptyState);
		}

		GLfloat color = dialogText.transparency;
		if (color > 0.0) {

			glEnable(GL_TEXTURE_2D);
			if (color > 0.0) {
				glTranslatef(-SCREEN_WIDTH / 2 - dialogText.translateX, (i - 5) * 20 - dialogText.translateY, 0);
				setQuadStripSize(textSurfaceWidth, textSurfaceHeight, quadStripVertices);
				glTexCoordPointer(2, GL_FLOAT, 0, texCoordsLandscape);
				glBindTexture(GL_TEXTURE_2D, text_texture);
				glColor4f(color, color, color, 1.0);
				glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
				glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
				glTranslatef(SCREEN_WIDTH / 2 + dialogText.translateX, (-i + 5) * 20 + dialogText.translateY, 0);
			}
		} else if (color < 0.0) {
			setDimmed(false);
		}
	}
}

