/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#include "TransitionState.h"
#include "Transition.h"
#include "transitions/EmptyTransition.h"
#include "../main.h"

TransitionState::TransitionState() {
	transitionIn = EmptyTransition::instance();
	transitionOut = EmptyTransition::instance();
}

void TransitionState::setTransitionIn(Transition* transitionIn) {
	if (transitionIn != NULL) {
		this -> transitionIn = transitionIn;
	} else {
		this -> transitionIn = EmptyTransition::instance();
	}
}

void TransitionState::setTransitionOut(Transition* transitionOut) {
	if (transitionOut != NULL) {
		this -> transitionOut = transitionOut;
	} else {
		this -> transitionOut = EmptyTransition::instance();
	}
}

TransitionState::~TransitionState() {
	// TODO Auto-generated destructor stub
}
