#include <json/json.h>
#include <json/json_object_private.h>
#define CLOUDMADE_QUERY_URL "http://geocoding.cloudmade.com/e4b1777b4b5154d69dbfc4678216183a/geocoding/v2/find.js?query=%s&return_location=true"
#define QUERY_TMP_FILENAME "/tmp/cloudgps-query-tmp.js"

#define KEY_FEATURES "features"
#define KEY_CENTROID "centroid"
#define KEY_COORDINATES "coordinates"
#define KEY_BOUNDS "bounds"
#define KEY_PROPERTIES "properties"
#define KEY_NAME "name"
#define KEY_IS_IN "is_in"
#define KEY_WIKIPEDIA "Wikipedia"

typedef struct {
   const char* name;
   const char* description;
   const char* wikipedia;
   WorldCoordinate centroid;
   WorldCoordinate bounds[2];
} GeoCodeResult;

void readWorldCoordinate(json_object * jobj, WorldCoordinate *wc) {
    wc -> latitude = json_object_get_double(json_object_array_get_idx(jobj, 0));
    wc -> longitude = json_object_get_double(json_object_array_get_idx(jobj, 1));
}


// features ->
//             centroid -> coordinates -> array[2] -> double
//             bounds -> array[2] -> array[2] -> double
//             properties ->
//                            name
//                            is_in
int geocode(char* query) {
    // TODO encode query, ie spaces for '+', any special characters?
    char *url, *json_string;
    int i;
    size_t lenght;
    asprintf(&url, CLOUDMADE_QUERY_URL, query);
    GList *results = NULL;

    if (downloadAndSave(url, QUERY_TMP_FILENAME)) {
        if (g_file_get_contents(QUERY_TMP_FILENAME, &json_string, &lenght, NULL)) {
//            fprintf(stderr, "%s\n", json_string);
            json_object * jobj = json_tokener_parse(json_string);
            json_object * features = json_object_object_get(jobj, KEY_FEATURES);
            if (features != NULL) {
                lenght = json_object_array_length(features);
                for (i = 0; i < lenght; i++) {
                    json_object * feature = json_object_array_get_idx(features, i);
                    GeoCodeResult * result = calloc(1, sizeof(GeoCodeResult));
                    readWorldCoordinate(json_object_object_get(json_object_object_get(feature, KEY_CENTROID), KEY_COORDINATES), &result -> centroid);
                    readWorldCoordinate(json_object_array_get_idx(json_object_object_get(feature, KEY_BOUNDS), 0), &result -> bounds[0]);
                    readWorldCoordinate(json_object_array_get_idx(json_object_object_get(feature, KEY_BOUNDS), 1), &result -> bounds[1]);
                    json_object *properties = json_object_object_get(feature, KEY_PROPERTIES);
                    result -> name = json_object_get_string(json_object_object_get(properties, KEY_NAME));
                    result -> description = json_object_get_string(json_object_object_get(properties, KEY_IS_IN));
                    result -> wikipedia = json_object_get_string(json_object_object_get(properties, KEY_WIKIPEDIA));
                    //fprintf(stderr, "Name: '%s' Description: '%s', center: %f, %f, Wikipedia: '%s'\n", result -> name, result -> description, result -> centroid.latitude, result -> centroid.latitude, result-> wikipedia == NULL ? "null": result -> wikipedia);
                    results = g_list_append(results, result);
                }
            }

            g_free(json_string);
            return TRUE;
        } else {
            fprintf(stderr, "Unable to read query results from %s\n", QUERY_TMP_FILENAME);
            return FALSE;
        }
    }
    return FALSE;
}
