/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

// those need updating on portrait/landscape change.
GList* volatileUiElems = NULL;

void loadTexture(Texture* texture, char* filename) {
    SDL_Surface* textureRGB = NULL;
    //    fprintf(stderr, "loading texture from %s\n", filename);
    textureRGB = loadTextureFromFile(filename, NULL);
    //    fprintf(stderr, "loadTextureFromFile returned: %p\n", textureRGB);
    if (textureRGB != NULL) {
        texture -> size = textureRGB -> w;
        texture -> name = createTexture(convert8888to4444(textureRGB), texture->size, texture-> size, FALSE);
    } else {
        fprintf(stderr, "loadTexture %s failed\n", filename);
    }
}

UiElement* createUiElement(char* texture, char* mask, int landscapex, int landscapey, int portraitx, int portraity, void(*handlePressed)(),
        void(*handleDragged)(), int addToList) {
    UiElement* element = calloc(1, sizeof(UiElement));
    if (element == NULL) {
        fprintf(stderr, "memory allocation failed in createUiElement\n");
        return NULL;
    }

    loadTexture(&(element -> mask), mask);
    loadTexture(&(element -> texture), texture);

    landscapex -= (element -> texture.size) / 2;
    landscapey -= (element -> texture.size) / 2;
    portraitx -= (element -> texture.size) / 2;
    portraity -= (element -> texture.size) / 2;

    element -> landscapex = landscapex;
    element -> landscapey = landscapey;
    element -> x = landscapex;
    element -> y = landscapey;
    element -> portraitx = portraitx;
    element -> portraity = portraity;
    element -> status = UI_SHOWN;
    element -> color.r = 1.0;
    element -> color.g = 1.0;
    element -> color.b = 1.0;
    element -> color.a = 1.0;
    element -> handlePressed = handlePressed;
    element -> handleDragged = handleDragged;
    element -> texCoords = texCoordsLandscape[0];

    //    fprintf(stderr, "addtoqueue = %d\n", addToQueue);
    if (addToList) {
        uiElems = g_list_append(uiElems, element);
    }

    return element;
}

void destroyUiElement(UiElement* elem) {
    fprintf(stderr, "STUB - destroyUiElement(UiElement* elem)\n");
}

void drawUiElement(UiElement* elem) {

    glTranslatef(elem -> x, elem -> y, 0);
    glEnable(GL_BLEND);
    // mask
    glBlendFunc(GL_DST_COLOR, GL_ZERO);
    glColor4f(1.0, 1.0, 1.0, 1.0);
    glBindTexture(GL_TEXTURE_2D, elem->mask.name);
    setQuadSize(elem->mask.size, elem->mask.size, quadVertices);
    glVertexPointer(3, GL_FLOAT, 0, quadVertices);
    glTexCoordPointer(2, GL_FLOAT, 0, elem->texCoords);
    glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);

    // texture
    glColor4f(elem->color.r, elem->color.g, elem->color.b, elem->color.a);
    glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
    glBindTexture(GL_TEXTURE_2D, elem-> texture.name);
    glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);

    glTranslatef(-elem -> x, -elem -> y, 0);
}

void loadUI() {
    loadTexture(&fontMedium, "/opt/cloudgps/res/font-medium.png");
    loadTexture(&fontMediumMask, "/opt/cloudgps/res/font-medium-mask.png");
    //loadTexture(&barbgmask, "/opt/cloudgps/res/bar-bg-mask.png");
    //    loadTexture(&barbg, "/opt/cloudgps/res/bar-bg.png");
    //    loadTexture(&barbg, "/opt/cloudgps/res/zoom-minus-mask.png");

    zoomOut = createUiElement("/opt/cloudgps/res/zoom-minus.png", "/opt/cloudgps/res/zoom-minus-mask.png", 50, SCREEN_HEIGHT - 50, SCREEN_WIDTH - 50,
            SCREEN_HEIGHT - 50, &tileEngineZoomOut, &tileEngineZoomOut, TRUE);

    zoomIn = createUiElement("/opt/cloudgps/res/zoom-plus.png", "/opt/cloudgps/res/zoom-plus-mask.png", SCREEN_WIDTH - 50, SCREEN_HEIGHT - 50,
            SCREEN_WIDTH - 50, 50, &tileEngineZoomIn, &tileEngineZoomIn, TRUE);
    gotomypos = createUiElement("/opt/cloudgps/res/gotomypos.png", "/opt/cloudgps/res/gotomypos-mask.png", SCREEN_WIDTH - 150, SCREEN_HEIGHT - 50,
            SCREEN_WIDTH - 50, 150, &tileEngineGotomypos, &tileEngineGotomypos, TRUE);
    position = createUiElement("/opt/cloudgps/res/position.png", "/opt/cloudgps/res/position-mask.png", 0, 0, 0, 0, NULL, NULL, TRUE);
    view2d = createUiElement("/opt/cloudgps/res/2d.png", "/opt/cloudgps/res/2d-mask.png", 150, SCREEN_HEIGHT - 50, SCREEN_WIDTH - 50, SCREEN_HEIGHT
            - 150, &tileEngineViewMode2D, NULL, TRUE);
    view2d -> status = UI_HIDDEN;
    view3d = createUiElement("/opt/cloudgps/res/3d.png", "/opt/cloudgps/res/3d-mask.png", 150, SCREEN_HEIGHT - 50, SCREEN_WIDTH - 50, SCREEN_HEIGHT
            - 150, &tileEngineViewMode3D, NULL, TRUE);
    crosshair = createUiElement("/opt/cloudgps/res/crosshair.png", "/opt/cloudgps/res/crosshair-mask.png", SCREEN_WIDTH / 2, SCREEN_HEIGHT / 2,
            SCREEN_WIDTH / 2, SCREEN_HEIGHT / 2, NULL, NULL, TRUE);
    volatileUiElems = g_list_append(volatileUiElems, zoomOut);
    volatileUiElems = g_list_append(volatileUiElems, view2d);
    volatileUiElems = g_list_append(volatileUiElems, view3d);
    volatileUiElems = g_list_append(volatileUiElems, gotomypos);
    volatileUiElems = g_list_append(volatileUiElems, zoomIn);

}

void drawUiElems() {
    GList* elem = uiElems;

    while (elem != NULL) {
        UiElement* uiElem = (UiElement*) elem -> data;
        if (uiElem -> status != UI_HIDDEN && uiElem != position) {
            drawUiElement(elem -> data);
        }
        elem = elem -> next;
    }
}

GLfloat satelliteBars[18 * MAX_SATTELITES];
GLfloat satelliteBarOutlines[24 * MAX_SATTELITES];
GLfloat satelliteBarColors[4 * 6 * MAX_SATTELITES];
GLfloat satelliteBarOutlineColors[4 * 8 * MAX_SATTELITES];
int satelliteBarOutlinesInitialized = FALSE;

void drawSatelliteBars(GLfloat barHeight, GLfloat barWidth, GLfloat separation) {
    int i, j;
    GLfloat x;
    if (!satelliteBarOutlinesInitialized) {
        for (i = 0; i < MAX_SATTELITES; i++) {
            x = i * (barWidth + separation);
            /*    1
             *  -----
             * |     |
             * |4    |2
             * |     |
             *  -----
             *    3
             */
            // 1
            satelliteBarOutlines[i * 24] = x;
            satelliteBarOutlines[i * 24 + 1] = 0.0;
            satelliteBarOutlines[i * 24 + 2] = 0.0;

            satelliteBarOutlines[i * 24 + 3] = x + barWidth;
            satelliteBarOutlines[i * 24 + 4] = 0.0;
            satelliteBarOutlines[i * 24 + 5] = 0.0;

            //2
            satelliteBarOutlines[i * 24 + 6] = x + barWidth;
            satelliteBarOutlines[i * 24 + 7] = 0.0;
            satelliteBarOutlines[i * 24 + 8] = 0.0;

            satelliteBarOutlines[i * 24 + 9] = x + barWidth;
            satelliteBarOutlines[i * 24 + 10] = barHeight;
            satelliteBarOutlines[i * 24 + 11] = 0.0;

            //3
            satelliteBarOutlines[i * 24 + 12] = x + barWidth;
            satelliteBarOutlines[i * 24 + 13] = barHeight;
            satelliteBarOutlines[i * 24 + 14] = 0.0;

            satelliteBarOutlines[i * 24 + 15] = x;
            satelliteBarOutlines[i * 24 + 16] = barHeight;
            satelliteBarOutlines[i * 24 + 17] = 0.0;

            // 4
            satelliteBarOutlines[i * 24 + 18] = x;
            satelliteBarOutlines[i * 24 + 19] = barHeight;
            satelliteBarOutlines[i * 24 + 20] = 0.0;

            satelliteBarOutlines[i * 24 + 21] = x;
            satelliteBarOutlines[i * 24 + 22] = 0.0;
            satelliteBarOutlines[i * 24 + 23] = 0.0;
        }
        satelliteBarOutlinesInitialized = TRUE;
    }

    if (device && device -> satellites) {
        for (i = 0; i < MAX_SATTELITES; i++) {
            x = i * (barWidth + separation);
            if (i < device -> satellites -> len) {
                LocationGPSDeviceSatellite* sat = device -> satellites -> pdata[i];
                int signalHeight = (sat -> signal_strength) / 2;

                if (sat -> in_use) {
                    for (j = 0; j < 8; j++) {
                        satelliteBarOutlineColors[i * 32 + j * 4] = 1.0;
                        satelliteBarOutlineColors[i * 32 + j * 4 + 1] = 1.0;
                        satelliteBarOutlineColors[i * 32 + j * 4 + 2] = 1.0;
                        satelliteBarOutlineColors[i * 32 + j * 4 + 3] = 0.5;
                        if (j < 6) {
                            satelliteBarColors[i * 24 + j * 4] = 1.0;
                            satelliteBarColors[i * 24 + j * 4 + 1] = 1.0;
                            satelliteBarColors[i * 24 + j * 4 + 2] = 1.0;
                            satelliteBarColors[i * 24 + j * 4 + 3] = 0.5;
                        }
                    }
                } else {
                    for (j = 0; j < 8; j++) {
                        satelliteBarOutlineColors[i * 32 + j * 4] = 0.4;
                        satelliteBarOutlineColors[i * 32 + j * 4 + 1] = 0.4;
                        satelliteBarOutlineColors[i * 32 + j * 4 + 2] = 0.4;
                        satelliteBarOutlineColors[i * 32 + j * 4 + 3] = 0.5;
                        if (j < 6) {
                            satelliteBarColors[i * 24 + j * 4] = 0.4;
                            satelliteBarColors[i * 24 + j * 4 + 1] = 0.4;
                            satelliteBarColors[i * 24 + j * 4 + 2] = 0.4;
                            satelliteBarColors[i * 24 + j * 4 + 3] = 0.5;
                        }
                    }
                }

                /*  1,6         2
                 *    ---------
                 *   | \      |
                 *   |  \     |
                 *   |   \    |
                 *   |    \   |
                 *   |     \  |
                 *   |      \ |
                 *  5 --------3,4
                 *
                 */
                // 1
                satelliteBars[i * 18] = x;
                satelliteBars[i * 18 + 1] = barHeight - 1 - signalHeight;
                satelliteBars[i * 18 + 2] = 0.0;

                // 2
                satelliteBars[i * 18 + 3] = x + barWidth;
                satelliteBars[i * 18 + 4] = barHeight - 1 - signalHeight;
                satelliteBars[i * 18 + 5] = 0.0;

                // 3
                satelliteBars[i * 18 + 6] = x + barWidth;
                satelliteBars[i * 18 + 7] = barHeight - 1;
                satelliteBars[i * 18 + 8] = 0.0;

                // 4
                satelliteBars[i * 18 + 9] = x + barWidth;
                satelliteBars[i * 18 + 10] = barHeight - 1;
                satelliteBars[i * 18 + 11] = 0.0;

                // 5
                satelliteBars[i * 18 + 12] = x;
                satelliteBars[i * 18 + 13] = barHeight - 1;
                satelliteBars[i * 18 + 14] = 0.0;

                // 6
                satelliteBars[i * 18 + 15] = x;
                satelliteBars[i * 18 + 16] = barHeight - 1 - signalHeight;
                satelliteBars[i * 18 + 17] = 0.0;

                // TODO - this should be optimized and passed to opengl in one call.
                sprintf(buf, "%d", sat -> prn);
                x += 5 - stringWidth(buf) / 2;

                glTranslatef(x, barHeight, 0);
                drawString(buf, .7 + .3 * (i % 2), .7 + .3 * (i % 2), .7 + .3 * (i % 2), TRUE);
                glTranslatef(-x, -barHeight, 0);

            } else {
                for (j = 0; j < 8; j++) {
                    satelliteBarOutlineColors[i * 32 + j * 4] = 0.4;
                    satelliteBarOutlineColors[i * 32 + j * 4 + 1] = 0.4;
                    satelliteBarOutlineColors[i * 32 + j * 4 + 2] = 0.4;
                    satelliteBarOutlineColors[i * 32 + j * 4 + 3] = 0.5;
                    if (j < 6) {
                        satelliteBarColors[i * 24 + j * 4] = 0.4;
                        satelliteBarColors[i * 24 + j * 4 + 1] = 0.4;
                        satelliteBarColors[i * 24 + j * 4 + 2] = 0.4;
                        satelliteBarColors[i * 24 + j * 4 + 3] = 0.5;
                    }
                }
            }
        }
    }

    glBindTexture(GL_TEXTURE_2D, 0);
    glEnableClientState(GL_COLOR_ARRAY);
    if (device -> satellites && device -> satellites -> len > 0) {
        glColorPointer(4, GL_FLOAT, 0, satelliteBarColors);
        glVertexPointer(3, GL_FLOAT, 0, satelliteBars);
        glDrawArrays(GL_TRIANGLES, 0, 6 * device -> satellites -> len);
    }

    glColorPointer(4, GL_FLOAT, 0, satelliteBarOutlineColors);
    glVertexPointer(3, GL_FLOAT, 0, satelliteBarOutlines);
    glDrawArrays(GL_LINES, 0, 8 * MAX_SATTELITES);
    glDisableClientState(GL_COLOR_ARRAY);
}

void drawStatusBar(Orientation orientation) {
    if (canvas.orientationTransition > 0.001 && canvas.orientationTransition < .999) {
        if (orientation == LANDSCAPE) {
            glTranslatef(-SCREEN_WIDTH * canvas.orientationTransition, 0, 0);
        } else {
            glTranslatef(0, SCREEN_HEIGHT * canvas.orientationTransition, 0);
        }
    } else {
        if (orientation != options.orientation) {
            return;
        }
        if (orientation == PORTRAIT) {
            glTranslatef(0, SCREEN_HEIGHT * canvas.orientationTransition, 0);
        }
    }
    if (orientation == PORTRAIT) {
        glRotatef(-90, 0.0, 0.0, 1.0);
    }
    glEnable(GL_BLEND);
    glBlendFunc(GL_DST_COLOR, GL_ZERO);
    glColor4f(.4, .4, .4, 0.5);

    GLfloat statusBarHeight;

    if (orientation == LANDSCAPE) {
        statusBarHeight = 50;
    } else {
        statusBarHeight = 70;
    }

    // statusbar background - half transparent grey rectangle
    setQuadSize(SCREEN_WIDTH, statusBarHeight, quadVertices);
    glBindTexture(GL_TEXTURE_2D, 0);
    glVertexPointer(3, GL_FLOAT, 0, quadVertices);
    glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);

    glTranslatef(10, 5, 0);
    if (orientation == LANDSCAPE) {
        sprintf(buf, "Downloaded: %.2f kb", downloaded / 1024.0);
    } else {
        sprintf(buf, "D/l: %.2f kb", downloaded / 1024.0);
    }
    drawString(buf, 1.0, 1.0, 1.0, FALSE);
    glTranslatef(0, 20, 0);
    switch (device -> fix -> mode) {
        case LOCATION_GPS_DEVICE_MODE_2D:
            sprintf(buf, "GPS fix: 2D");
            break;
        case LOCATION_GPS_DEVICE_MODE_3D:
            sprintf(buf, "GPS fix: 3D");
            break;
        case LOCATION_GPS_DEVICE_MODE_NOT_SEEN:
            sprintf(buf, "GPS fix: not seen");
            break;
        case LOCATION_GPS_DEVICE_MODE_NO_FIX:
            sprintf(buf, "GPS fix: no fix");
            break;
    }
    drawString(buf, 1.0, 1.0, 1.0, FALSE);
    if (orientation == LANDSCAPE) {
        glTranslatef(180, -20, 0);
    } else {
        glTranslatef(120, -20, 0);
    }

    if (device -> satellites_in_use > 0 && device -> fix -> fields | LOCATION_GPS_DEVICE_ALTITUDE_SET && !isnan(device -> fix -> altitude)) {
        sprintf(buf, "Altitude: %.2f m", device -> fix -> altitude);
    } else {
        sprintf(buf, "Altitude: ---");
    }
    drawString(buf, 1.0, 1.0, 1.0, FALSE);
    glTranslatef(0, 20, 0);

    if (device -> satellites_in_use > 0 && device -> fix -> fields | LOCATION_GPS_DEVICE_SPEED_SET && !isnan(device -> fix -> speed)) {
        sprintf(buf, "Speed: %.2f km/h", device -> fix -> speed);
    } else {
        sprintf(buf, "Speed: ---");
    }
    drawString(buf, 1.0, 1.0, 1.0, FALSE);

    if (orientation == LANDSCAPE) {
        glTranslatef(SCREEN_WIDTH - 280, -20, 0);
    } else {
        glTranslatef(-120, 20, 0);
    }

    sprintf(buf, "FPS: %.1f", fps);
    drawString(buf, 1.0, 1.0, 1.0, FALSE);
    if (orientation == LANDSCAPE) {
        glTranslatef(0, 20, 0);
    } else {
        glTranslatef(120, 0, 0);
    }

    sprintf(buf, "Battery: %d%%", batteryPercentage);
    drawString(buf, 1.0, 1.0, 1.0, FALSE);

    if (orientation == LANDSCAPE) {
        glTranslatef(-250, -23, 0);
    } else {
        glTranslatef(125, -30, 0);
    }

    glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
    glBindTexture(GL_TEXTURE_2D, 0);
    drawSatelliteBars(32, 12, 6);

    if (orientation == LANDSCAPE) {
        glTranslatef(SCREEN_WIDTH * canvas.orientationTransition, 0, 0);
    }
}

int processUiMouse() {
    GList* elem = uiElems;

    if (mouse.button == 1) {
        if (mouse.oldButton == 0) {
            while (elem != NULL) {
                UiElement* e = (UiElement*) elem->data;
                if (e -> status == UI_SHOWN && mouse.x >= e->x && mouse.x <= e->x + e->texture.size && mouse.y >= e->y && mouse.y <= e->y
                        + e->texture.size) {
                    pressedUiElem = e;
                    if (pressedUiElem -> handlePressed != NULL) {
                        pressedUiElem -> handlePressed();
                        return TRUE;
                    }
                    return FALSE;
                }

                elem = elem -> next;
            }
            pressedUiElem = NULL;
        } else {
            if (pressedUiElem != NULL) {
                if (pressedUiElem -> handleDragged != NULL) {
                    pressedUiElem -> handleDragged();
                }
                return TRUE;
            }
        }
    }
    return FALSE;
}

void updateUi() {
    if (device && device -> fix) {

        if (device -> fix -> fields | LOCATION_GPS_DEVICE_LATLONG_SET) {
            position -> status = UI_SHOWN;
            WorldCoordinate wc;
            wc.latitude = device -> fix -> latitude;
            wc.longitude = device -> fix -> longitude;
            TileCoordinate tc;
            toTileCoordinate(&wc, &tc, canvas.zoom);

            toScreenCoordinate(&tc, &position ->x, &position -> y);
            position -> x -= position -> texture.size / 2;
            position -> y -= position -> texture.size / 2;

            position -> color.a = 0.75 + 0.25 * sin(nowMillis / 500.0);
            position -> color.r = position -> color.a;
            position -> color.g = position -> color.a;

            if (device -> satellites_in_use > 0) {
                position -> color.b = 1.0 - position -> color.a;
            } else {
                position -> color.b = position -> color.a;
            }

            //            fprintf(stderr, "position on screeen: x = %f, y = %f, color = %f\n", position -> x, position -> y, position -> color.a);
        } else {
            position -> status = UI_HIDDEN;
        }
    }

    gotomypos -> color.r = canvas.followingMypos * .3 + .4;
    gotomypos -> color.g = canvas.followingMypos * .3 + .4;
    gotomypos -> color.b = canvas.followingMypos * .3 + .4;

    GList * volatileElem = volatileUiElems;
    if (canvas.orientationTransitionLinear > 0 && canvas.orientationTransitionLinear < 160) {
        int i = 0;
        while (volatileElem != NULL) {
            UiElement * elem = volatileElem -> data;

            if (canvas.orientationTransitionLinear < 80) {
                elem -> x = elem -> landscapex;
                elem -> y = elem -> landscapey;
                if (canvas.orientationTransitionLinear > i) {
                    GLfloat xxx = canvas.orientationTransitionLinear - i;
                    elem -> y += pow((xxx), 1.6);
                }
                elem -> texCoords = texCoordsLandscape[0];
            } else {
                elem -> x = elem -> portraitx;
                elem -> y = elem -> portraity;
                elem -> texCoords = texCoordsPortrait[0];
                if (160 - canvas.orientationTransitionLinear > i) {
                    GLfloat xxx = 160 - (canvas.orientationTransitionLinear) - i;
                    elem -> x += pow(xxx, 1.6);
                }
            }
            volatileElem = volatileElem -> next;
            i += 10;
        }
    } else {
        while (volatileElem != NULL) {
            UiElement * elem = volatileElem -> data;
            if (options.orientation == LANDSCAPE) {
                elem -> x = elem -> landscapex;
                elem -> y = elem -> landscapey;
                elem -> texCoords = texCoordsLandscape[0];
            } else {
                elem -> x = elem -> portraitx;
                elem -> y = elem -> portraity;
                elem -> texCoords = texCoordsPortrait[0];
            }
            volatileElem = volatileElem -> next;
        }
    }
}

