/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */


/* function to load in bitmap as SDL surface ready to be used in OpenGL */
SDL_Surface* loadTextureFromFile(char *filename, t_tile* tile) {
    SDL_Surface *surface;
    SDL_Surface *surfaceRGB;
    SDL_Rect rect;

//    long startTime = SDL_GetTicks();
//    fprintf(stderr, "IMG_Load('%s')\n", filename);

    if ((surface = IMG_Load(filename))) {
//        fprintf(stderr, "IMG_Load succeeded\n");

        // convert loaded image to RGBA image and then create opengl texture
        surfaceRGB = SDL_CreateRGBSurface(SDL_SWSURFACE, surface->w, surface->h, 32, 0x000000FF, 0x0000FF00, 0x00FF0000, 0xFF000000);
//        fprintf(stderr, "SDL_CreateRGBSurface succeeded %p\n", surfaceRGB);

        if (surfaceRGB) {
            rect.x = 0;
            rect.y = 0;
            rect.w = surface->w;
            rect.h = surface->h;
            SDL_BlitSurface(surface, &rect, surfaceRGB, &rect);
            SDL_FreeSurface(surface);

            return surfaceRGB;
        } else {
            fprintf(stderr, "createRGBsurface failed \n");
        }
    } else {
        if (tile) {
            remove(filename);
//            tile -> errorMessage = SDL_GetError();
//            fprintf(stderr, "loading from file '%s' failed in %ld ms, error: %s\n", filename, (SDL_GetTicks() - startTime), tile -> errorMessage);
        }
    }
    //free(filename);
    return NULL;
}

GLushort * convert8888to4444(SDL_Surface* surfaceRGBA) {
    GLushort * pixels4444 = NULL;
    GLubyte* pixels8888 = surfaceRGBA->pixels;
    int i, j;
    pixels4444 = malloc(surfaceRGBA -> w * surfaceRGBA -> h * sizeof(GLushort));
    for (i = 0; i < surfaceRGBA -> w * surfaceRGBA -> h; i++) {
        j = i << 2;
        pixels4444[i] = (pixels8888[j + 3] >> 4) + ((pixels8888[j + 2] >> 4) << 4) + ((pixels8888[j + 1] >> 4) << 8) + ((pixels8888[j] >> 4) << 12);
    }
    return pixels4444;
}


GLuint createTexture(GLushort * pixels4444, int w, int h, int isTile) {
    GLuint texture;

    glGenTextures(1, &texture);
    glBindTexture(GL_TEXTURE_2D, texture);

    glTexParameteri(GL_TEXTURE_2D, GL_GENERATE_MIPMAP, GL_TRUE);
    if (isTile && options.mipmapToggle) {
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_NEAREST);
    } else {
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    }
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, w, h, 0, GL_RGBA, GL_UNSIGNED_SHORT_4_4_4_4, pixels4444);

    return texture;
}

long lastTileSync = 0;

// When changing zoom level a lot of tiles are start loading at the same time. They usually
// all load within 1 second but we want to synchronize their state change so that they will
// start showing on screen simultaneuously.
void updateSyncWaitTiles() {
    if (syncLoadedTilesAppearance == 0) {
        return;
    }
    int i, j;
    int loadingCount = 0, syncWaitCount = 0;
    for (i = 0; i < TILES_X; i++) {
        for (j = 0; j < TILES_Y; j++) {
            if (tiles[i][j][currentTilesIdx] -> state == STATE_LOADING) {
                loadingCount++;
            } else if (tiles[i][j][currentTilesIdx] -> state == STATE_LOADED_SYNC_WAIT) {
                syncWaitCount++;
            }
        }
    }

    if (lastTileSync == 0 && (loadingCount > 0 || syncWaitCount > 0)) {
        lastTileSync = nowMillis;
    }

    if ((lastTileSync != 0 && nowMillis - lastTileSync > 1000 && syncWaitCount > 0)) {
        for (i = 0; i < TILES_X; i++) {
            for (j = 0; j < TILES_Y; j++) {
                if (tiles[i][j][currentTilesIdx] -> state == STATE_LOADED_SYNC_WAIT) {
                    tiles[i][j][currentTilesIdx]->state = STATE_LOADED;
                    tiles[i][j][currentTilesIdx]->stateChangeTime = nowMillis;
                    //fprintf(stderr, "%ld - synced tile %d, %d\n", nowMillis, i, j);
                }
            }
        }
        if (loadingCount == 0) {
            lastTileSync = 0;
        } else {
            lastTileSync = nowMillis;
        }
        syncLoadedTilesAppearance = 0;
    }
}
