/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */
typedef struct element {
    void * data;
    struct element * next;
    struct element * previous;
} element;

typedef struct {
    element * first;
    element * last;
    int elemCount;
    SDL_mutex *mutex;
} queue;

queue* createQueue() {
    queue* queue = malloc(sizeof(queue));
    if (queue == NULL) {
        fprintf(stderr, "memory allocation error in createQueue\n");
        return NULL;
    }
    queue -> first = NULL;
    queue -> last = NULL;
    queue -> elemCount = 0;
    queue ->mutex = SDL_CreateMutex();
//    fprintf(stderr, "createQueue success\n");
    return queue;
}

void enqueue(queue* queue, void *data) {
    element * element = calloc(sizeof(element), 1);
            //, *e;
    if (SDL_mutexP(queue -> mutex) == -1) {
        fprintf(stderr, "mutexP failed in enqueue\n");
        return;
    }
//    fprintf(stderr, "entering enqueue, queue -> first == %p queue -> last == %p \n", queue->first, queue-> last);

    if (element == NULL) {
        fprintf(stderr, "memory allocation error in enqueue\n");
        return;
    }
    element -> data = data;

    if (queue -> last == NULL) {
        element -> next = NULL;
        element -> previous = NULL;
        queue -> first = element;
        queue -> last = element;
        queue -> elemCount = 1;
    } else {
        element -> previous = queue -> last;
        element -> next = NULL;
        queue -> last -> next = element;
        queue -> last = element;
        queue -> elemCount++;
    }
//    fprintf(stderr, "enqueue success, number of elements: %d\n", queue -> elemCount);

//    int c = 0;
//    if (queue -> first == NULL) {
//        fprintf(stderr, "queue -> first == NULL\n");
//    }
//    for (e = queue -> first; e != NULL; e = e -> next) {
//        fprintf(stderr, "%d, prev = %p, curr = %p, next = %p\n", c++, e-> previous, e, e->next);
//    }

    if (SDL_mutexV(queue->mutex) == -1) {
        fprintf(stderr, "mutexV failed in enqueue\n");
    }
}

void * dequeue(queue* queue) {
    if (queue -> first == NULL) {
//        fprintf(stderr, "dequeue on empty queue (1)\n");
        return NULL;
    }
    if (SDL_mutexP(queue -> mutex) == -1) {
        fprintf(stderr, "mutexP failed in dequeue\n");
        return NULL;
    }
    if (queue -> first == NULL) {
        if (SDL_mutexV(queue->mutex) == -1) {
            fprintf(stderr, "mutexV failed in dequeue (1)\n");
        }
//        fprintf(stderr, "dequeue on empty queue (2)\n");
        return NULL;
    }
    element * first = queue -> first;
    void * data = first -> data;
    queue -> first = queue -> first -> next;
    if (queue -> first != NULL) {
        queue -> first -> previous = NULL;
    } else {
        queue -> last = NULL;
    }


    free(first);
    queue -> elemCount--;
//    fprintf(stderr, "dequeue success, queue elemCount = %d\n", queue -> elemCount);
//    fprintf(stderr, "leaving dequeue, queue -> first == %p queue -> last == %p \n", queue->first, queue-> last);

//    int c = 0;
//    element *e;
//    for (e = queue -> first; e != NULL; e = e -> next) {
//        fprintf(stderr, "%d, prev = %p, curr = %p (data == %p), next = %p\n", c++, e-> previous, e, (e == NULL ? NULL : e->data), e->next);
//    }
    if (SDL_mutexV(queue->mutex) == -1) {
        fprintf(stderr, "mutexV failed in dequeue(2)\n");
    }
    return data;
}

int queueSize(queue * queue) {
    return queue -> elemCount;
}
