#!/bin/sh

killappman () {
killall hildon-application-manager > \/tmp\/output.txt 2> \/dev\/null
killall apt-worker > \/tmp\/output.txt 2> \/dev\/null
killall apt-worker.real > \/tmp\/output.txt 2> \/dev\/null
}


clean () { 
apt-get clean | zenity --progress --pulsate --title="Clean" --text="Attendez que la barre charge"
	dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
		org.freedesktop.Notifications.SystemNoteInfoprint string:"Clean Effectué"
}

autoclean () { 
apt-get autoclean | zenity --progress --pulsate --title="Autoclean" --text="Attendez que la barre charge"
	dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
		org.freedesktop.Notifications.SystemNoteInfoprint string:"Autoclean Effectué"
}

autoremove () {
apt-get autoremove | zenity --progress --pulsate --title="Autoremove" --text="Attendez que la barre charge"
	dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
		org.freedesktop.Notifications.SystemNoteInfoprint string:"Autoremove Effectué"
}

purge () {
apt-get purge | zenity --title="Output Purge" --text-info
	dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
		org.freedesktop.Notifications.SystemNoteInfoprint string:"Purge Effectué"
}

connessione () {
dbus-send --system --type=method_call --dest=com.nokia.icd_ui /com/nokia/icd_ui com.nokia.icd_ui.show_conn_dlg boolean:false
	sleep 9
		dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Connexion... S'il vous plaît patienter..."
}

update () {
apt-get update | zenity --title="Output Update" --text-info
	dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Update Terminé" 
}

popup_ann () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Opération annulée"
}

aggiornamenti () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Updates effectuée"
}

noaggiornamenti () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Updates ne sont pas exécutées!"
}

riavvio () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
	org.freedesktop.Notifications.SystemNoteInfoprint string:"Redémarrage... S'il vous plaît patienter..."
		reboot
}

backupcreato () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Backup créé!"
}

opincorso () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"De travail... S'il vous plaît patienter..."
}

ripristino () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Recovery fait"
}

paccinst () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Installé le paquet"
}

paccdis () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Désinstallé le paquet"
}

applicazioni () {
zenity --title=CleanN900 --height 250 --list  --text "Sélectionnez les opérations que vous êtes intéressé par" --column "Options" "Créer une sauvegarde de vos applications" "Restauration à partir d'applications de sauvegarde" "Installez un paquet" "Remove paquet spécifiques" "Reboot"
}

gestoreaperto () {
zenity --warning --title CleaN900 --text "Vous avez des applications exploitant ouverte! Pour fermer cliquez sur OK, sinon pas dans le vide"
}

primostep () {
zenity --title=CleanN900 --height 350 --list  --text "Sélectionnez les opérations que vous êtes intéressé par" --column "Options" "clean" "autoclean" "autoremove" "purge" "Update" "Upgrade" "Applications" "Reboot"
}

ricconn () {
zenity --warning --title CleaN900 --text "Vous devez avoir la connexion active, mieux wifi. Si vous souhaitez vous connecter cliquez sur OK, sinon pas dans le vide"
}

selbackup () {
zenity --title CleaN900 --file-selection --text='Sélectionnez le file' --filename=/home/user/MyDocs/clean900/ --file-filter "*.txt"
}

seldeb () {
zenity --title CleaN900 --file-selection --text='Sélectionnez le deb' --filename=/home/user/MyDocs/ --file-filter "*.deb"
}

rempac () {
zenity --entry --title='Supprimer' --text='Entrez le nom du paquet'
}

waitdis () {
zenity --progress --pulsate --title="Désinstallation" --text="Attendez que la barre charge"
}
