/*!
** @file	FocusButton.h
**
** @brief	Custom button widget for focus mode
**
*/
#ifndef __focusbutton__h
#define __focusbutton__h

/*---------------------------------------------------------------------------
** Includes
*/
#include <QToolButton>
#include "camera.h"

/*---------------------------------------------------------------------------
** Defines and Macros
*/

/*---------------------------------------------------------------------------
** Typedefs
*/

/*---------------------------------------------------------------------------
** Local function prototypes
*/

/*---------------------------------------------------------------------------
** Data
*/

class FocusButton : public QToolButton {
	Q_OBJECT

public:
	//--------------------------------------------------------------------------
	/*!
	** @brief   	Constructor
	*/
	FocusButton(QWidget* parent = NULL);

	//--------------------------------------------------------------------------
	/*!
	** @brief   	Destructor
	*/
	virtual ~FocusButton();
	
	//--------------------------------------------------------------------------
	/*!
	** @brief		Set the button to display the current focus mode
	**
	** @param[In]	New focus mode
	**
	*/
	void set_focus_mode(CAMERA_FOCUS_MODE new_focus_mode);

signals:
	//--------------------------------------------------------------------------
	/*!
	** @brief		Signal that is sent when the focus mode changes
	**
	** @param[In]	New focus mode selected by user
	**
	*/
	void focus_mode_changed(CAMERA_FOCUS_MODE new_focus_mode);

private slots:
	//--------------------------------------------------------------------------
	/*!
	** @brief		Slot that is called when the user selects the button
	**
	*/
	void clicked(bool checked = false);

private:
	int		m_focus_mode;
};

#endif
