using GLib;

[DBus (name = "org.maemo.cinaest.Downloader", signals = ("progress", "description_changed"))]
public interface IMDbDownloader {
	public const string DBUS_SERVICE = "org.maemo.cinaest.IMDb";
	public const string DBUS_OBJECT = "/org/maemo/cinaest/imdb";
	public const string DBUS_IFACE = "org.maemo.cinaest.Downloader";
	public const int MOVIES = 0x1;
	public const int GENRES = 0x2;
	public const int RATINGS = 0x4;
	public const int AKAS = 0x4;
	public const int PLOTS = 0x10;
	public const int SERIES = 0x100;
	public const int TV = 0x200;
	public const int VIDEO = 0x400;
	public const int GAME = 0x800;
	public const int ADULT = 0x1000;

	public abstract void download (string mirror, int flags) throws DBus.Error;
	public abstract void cancel () throws DBus.Error;
	public abstract string[] get_mirrors () throws DBus.Error;

	public signal void progress (int percent);
	public signal void description_changed (string description);
}
