/* This file is part of Cinaest.
 *
 * Copyright (C) 2009 Philipp Zabel
 *
 * Cinaest is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Cinaest is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cinaest. If not, see <http://www.gnu.org/licenses/>.
 */

using Hildon;

public class CinaestProgram : Hildon.Program {
	SourceListWindow window;
	public static List<Plugin> plugins;

	construct {
		Environment.set_application_name ("Cinæst");

		window = new SourceListWindow ();
		window.destroy.connect (Gtk.main_quit);

		add_window (window);
	}

	public void register_plugins (Osso.Context context) {
		string plugin_path = Config.PKGLIBDIR;
		try {
			var directory = File.new_for_path (plugin_path);
			var enumerator = directory.enumerate_children (FILE_ATTRIBUTE_STANDARD_NAME, 0, null);

			FileInfo file_info;
			while ((file_info = enumerator.next_file (null)) != null) {
				string name = file_info.get_name ();

				if (name.has_suffix (".so")) {
					Plugin plugin;
					string path = Path.build_filename (plugin_path, name, null);

					var registrar = new PluginRegistrar<Plugin> (path);
					registrar.load ();

					plugin = registrar.new_object ();
					plugins.append (plugin);
					plugin.hello (window, context);
				}
			}

		} catch (Error e) {
			stderr.printf ("Error: %s\n", e.message);
		}
	}

	public void run () {
		foreach (Plugin plugin in plugins) {
			window.add_sources (plugin.get_sources ());
		}
		Gtk.main ();
	}

	static int main (string[] args) {
		Gtk.init (ref args);

		Intl.setlocale (LocaleCategory.ALL, "");
		Intl.bindtextdomain (Config.GETTEXT_PACKAGE, Config.LOCALEDIR);
		Intl.textdomain (Config.GETTEXT_PACKAGE);

		var osso_context = new Osso.Context ("org.maemo.cinaest", Config.VERSION, true, null);
		if (osso_context == null) {
			return Osso.Status.ERROR;
		}

		CinaestProgram app = new CinaestProgram ();
		app.register_plugins (osso_context);
		app.run ();

		return 0;
	}
}

